/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.core.type;

import java.lang.reflect.Type;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PrimitiveWrapperTypes {

    private static final ConcurrentMap<Type, Type> PRIMITIVE_WRAPPER_TYPES = new ConcurrentHashMap<Type, Type>();

    static {
        PRIMITIVE_WRAPPER_TYPES.put(byte.class, Byte.class);
        PRIMITIVE_WRAPPER_TYPES.put(short.class, Short.class);
        PRIMITIVE_WRAPPER_TYPES.put(int.class, Integer.class);
        PRIMITIVE_WRAPPER_TYPES.put(long.class, Long.class);
        PRIMITIVE_WRAPPER_TYPES.put(float.class, Float.class);
        PRIMITIVE_WRAPPER_TYPES.put(double.class, Double.class);
        PRIMITIVE_WRAPPER_TYPES.put(char.class, Character.class);
        PRIMITIVE_WRAPPER_TYPES.put(CharSequence.class, String.class);
        PRIMITIVE_WRAPPER_TYPES.put(void.class, Void.class);
        PRIMITIVE_WRAPPER_TYPES.put(boolean.class, Boolean.class);
    }

    public static boolean isPrimitiveType(Type type) {
        return PRIMITIVE_WRAPPER_TYPES.containsKey(type);
    }

    public static boolean isWrapperType(Type type) {
        return PRIMITIVE_WRAPPER_TYPES.containsValue(type);
    }

    public static boolean isPrimitiveOrWrapperType(Type type) {
        if (isPrimitiveType(type) || isWrapperType(type)) {
            return true;
        } else {
            return false;
        }
    }

    public static Type getWrapperType(Type type) {
        return PRIMITIVE_WRAPPER_TYPES.get(type);
    }

    public static Type getPrimitiveType(Class<?> type) {
        for (Entry<Type, Type> entry : PRIMITIVE_WRAPPER_TYPES.entrySet()) {
            if (entry.getValue().equals(type)) {
                return entry.getKey();
            }
        }
        return null;
    }
}
