/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.core;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.Reference;

import org.maru.core.MapFactory.InternalReferenceQueue;

public final class Reaper extends Thread {

    private ReferenceQueue<Object> queue;

    private static boolean executed = false;

    public static synchronized void execute() {
        if (!executed) {
            new Reaper().start();
            executed = true;
        }
    }

    public Reaper() {
        this.queue = InternalReferenceQueue.queue;
        setDaemon(true);
    }

    public void run() {
        Reference<?> ref;
        while(true) {
            try {
                ref = queue.remove();
                if (ref instanceof ReapableReference) {
                    ((ReapableReference) ref).reapReferent();
                }
                ref.clear();
            } catch (InterruptedException e) {
                // nothing to do, just ignore.
            }
        }
    }

}
