/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.core;

import java.lang.reflect.Type;

import org.maru.core.KeyGen.Composer;

/**
 * Key interface.
 *
 *
 */
public interface Key<T> {

    /**
     * Gets the type of key if the {@link Class} is key.
     *
     * @return class type.
     */
    public Type getType();

    /**
     * Gets the instance of key if the instance is key.
     *
     * @return instance.
     */
    public T getInstance();

    /**
     * Gets composer class implementing {@link Composer}.
     *
     * @return composer
     */
    public Composer getComposer();

}