/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maru.core.Key;
import org.maru.core.KeyGen;
import org.maru.core.util.ConditionUtil;
import org.maru.dog.DefinitionException;
import org.maru.dog.bind.BindingConfiguration;
import org.maru.dog.bind.OverridableBindingConfig;
import org.maru.dog.core.ClassChecker;
import org.maru.dog.core.Configuration;
import org.maru.dog.core.Operator;
import org.maru.dog.core.Syntax;
import org.maru.dog.declare.BindPointDeclarator;
import org.maru.dog.declare.BoundPointDeclarator;
import org.maru.dog.declare.BridgeBindingDeclarator;
import org.maru.dog.declare.ConverterFlagDeclarator;
import org.maru.dog.declare.DeclarativeBindingDeclarator;
import org.maru.dog.declare.TerminativeBindingDeclarator;

public final class BindingDeclarator
implements DeclarativeBindingDeclarator,
BoundPointDeclarator,
BridgeBindingDeclarator,
BindPointDeclarator,
ConverterFlagDeclarator,
TerminativeBindingDeclarator {
    private static final String ERROR_ARGUMENT_IS_NULL = "The argument is null";
    private static final String ERROR_DOSE_NOT_START_DECLARATION = "Dose not start declaration.";
    private boolean isDefining = false;
    private Key<?> currentDeclarationKey = null;
    private BindingConfiguration currentBindingConfig = null;
    final Map<Key<?>, List<Configuration>> configurationsMap = new HashMap();
    private final List<Operator> syntaxList = new ArrayList<Operator>();

    @Override
    public BoundPointDeclarator declareFor(Class<?> target) {
        if (this.isDefining) {
            throw new DefinitionException("The other definition is not complete.");
        }
        this.isDefining = true;
        ConditionUtil.verifyNotNull(target, (String)ERROR_ARGUMENT_IS_NULL);
        ClassChecker.checkClassType(target);
        return this.declareFor(KeyGen.getKey(target));
    }

    private BoundPointDeclarator declareFor(Key<?> key) {
        this.currentDeclarationKey = key;
        if (this.configurationsMap.containsKey(key)) {
            throw new DefinitionException("The same declaration has already existed.");
        }
        ArrayList configurations = new ArrayList();
        this.configurationsMap.put(key, configurations);
        return this;
    }

    @Override
    public BridgeBindingDeclarator bound(String name) {
        BindingDeclarator.checkState(this.isDefining, ERROR_DOSE_NOT_START_DECLARATION);
        ConditionUtil.verifyNotNull((Object)name, (String)ERROR_ARGUMENT_IS_NULL);
        this.putPreviousConfigurationIntoMap();
        this.currentBindingConfig = new OverridableBindingConfig();
        this.currentBindingConfig.setBoundName(name);
        this.syntaxList.add(Operator.BOUND);
        return this;
    }

    @Override
    public BindPointDeclarator from(Class<?> fromClass) {
        BindingDeclarator.checkState(this.isDefining, ERROR_DOSE_NOT_START_DECLARATION);
        ConditionUtil.verifyNotNull(fromClass, (String)ERROR_ARGUMENT_IS_NULL);
        ClassChecker.checkClassType(fromClass);
        this.confirmCurrentBindingConfigIsNotNull();
        this.currentBindingConfig.setInputClass(fromClass);
        this.syntaxList.add(Operator.FROM);
        return this;
    }

    @Override
    public ConverterFlagDeclarator bind(String name) {
        BindingDeclarator.checkState(this.isDefining, ERROR_DOSE_NOT_START_DECLARATION);
        ConditionUtil.verifyNotNull((Object)name, (String)ERROR_ARGUMENT_IS_NULL);
        this.confirmCurrentBindingConfigIsNotNull();
        this.currentBindingConfig.setBindName(name);
        this.syntaxList.add(Operator.BIND);
        return this;
    }

    @Override
    public BoundPointDeclarator converterOff() {
        BindingDeclarator.checkState(this.isDefining, ERROR_DOSE_NOT_START_DECLARATION);
        this.confirmCurrentBindingConfigIsNotNull();
        this.currentBindingConfig.setConverterOff(true);
        this.syntaxList.add(Operator.CONVERTER_OFF);
        return this;
    }

    @Override
    public DeclarativeBindingDeclarator end() {
        BindingDeclarator.checkState(this.isDefining, ERROR_DOSE_NOT_START_DECLARATION);
        this.putPreviousConfigurationIntoMap();
        this.currentDeclarationKey = null;
        this.currentBindingConfig = null;
        this.isDefining = false;
        return this;
    }

    private void putPreviousConfigurationIntoMap() {
        if (ConditionUtil.isNotNull((Object)this.currentBindingConfig)) {
            this.confirmSyntax();
            List<Configuration> configurations = this.configurationsMap.get(this.currentDeclarationKey);
            ConditionUtil.verifyNotNull(configurations);
            if (configurations.contains(this.currentBindingConfig)) {
                throw new DefinitionException("The Same definition has already existed.");
            }
            configurations.add(this.currentBindingConfig);
        }
    }

    private static void checkState(boolean isDefining, String message) {
        ConditionUtil.verifyState((boolean)isDefining, (RuntimeException)new DefinitionException(message));
    }

    private void confirmSyntax() {
        Operator[] operators = this.syntaxList.toArray(new Operator[this.syntaxList.size()]);
        ConditionUtil.verifyState((boolean)Syntax.checkSyntax(operators), (RuntimeException)new DefinitionException("Syntax error: " + Arrays.toString((Object[])operators) + " is illegal syntax."));
        this.syntaxList.clear();
    }

    private void confirmCurrentBindingConfigIsNotNull() {
        if (ConditionUtil.isNull((Object)this.currentBindingConfig)) {
            throw new DefinitionException("Encounters syntax error.");
        }
    }

    public Map<Key<?>, List<Configuration>> getConfigurationMap() {
        return this.configurationsMap;
    }
}

