/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maru.core.Key;
import org.maru.core.KeyGen;
import org.maru.core.Reaper;
import org.maru.core.type.PrimitiveWrapperTypes;
import org.maru.core.util.ConditionUtil;
import org.maru.dog.Config;
import org.maru.dog.Director;
import org.maru.dog.bind.InstanceBinderBuilder;
import org.maru.dog.bind.InternalCallableBinder;
import org.maru.dog.core.ClassChecker;
import org.maru.dog.core.Configuration;
import org.maru.dog.core.ObjectFactory;

public final class DirectorImpl
implements Director {
    private static final ThreadLocal<Map<Key<?>, List<Configuration>>> LOCAL_CONFIGURATIONS = new ThreadLocal<Map<Key<?>, List<Configuration>>>(){

        @Override
        protected synchronized Map<Key<?>, List<Configuration>> initialValue() {
            return new HashMap();
        }
    };

    public DirectorImpl(Config ... configs) {
        LOCAL_CONFIGURATIONS.remove();
        if (ConditionUtil.isNotNull((Object)configs) && configs.length > 0) {
            this.initialize(configs);
        }
    }

    private void initialize(Config ... configs) {
        Map<Key<?>, List<Configuration>> localConfigurations = LOCAL_CONFIGURATIONS.get();
        DirectorImpl.setupConfig(localConfigurations, Occasion.INITIALIZING, configs);
        LOCAL_CONFIGURATIONS.set(localConfigurations);
        Reaper.execute();
    }

    private static void setupConfig(Map<Key<?>, List<Configuration>> localConfigurations, Occasion occasion, Config ... configs) {
        for (Config config : configs) {
            config.make();
            Map<Key<?>, List<Configuration>> configurationsMap = config.getBindingDeclarator().getConfigurationMap();
            block5: for (Map.Entry<Key<?>, List<Configuration>> entry : configurationsMap.entrySet()) {
                Key<?> defKey = entry.getKey();
                List<Configuration> configurations = entry.getValue();
                if (configurations.size() <= 0) continue;
                switch (occasion) {
                    case INITIALIZING: {
                        if (!localConfigurations.containsKey(defKey)) {
                            localConfigurations.put(defKey, configurations);
                            continue block5;
                        }
                        throw new IllegalArgumentException("The definition related to " + defKey.toString() + " has already existed.");
                    }
                    case REPLACING: {
                        localConfigurations.put(defKey, configurations);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unexpected occasion");
            }
        }
    }

    @Override
    public <T, K> Director bind(T target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder<T, K> callableBinder = this.getBinder(target, inputs);
            callableBinder.callableBind();
        }
        return this;
    }

    @Override
    public <T, K> T getInstance(T target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder<T, K> callableBinder = this.getBinder(target, inputs);
            return callableBinder.callableBind();
        }
        return target;
    }

    @Override
    public <T, K> T getInstance(Class<T> target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target)) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            T instance = ObjectFactory.newInstance(target);
            InternalCallableBinder<T, K> callableBinder = this.getBinder(instance, inputs);
            return callableBinder.callableBind();
        }
        throw new IllegalArgumentException("The target argument is primitive or wrapper type. Can not bind dependencies to " + target.getName());
    }

    @Override
    public Director removeAllConfig() {
        LOCAL_CONFIGURATIONS.remove();
        return this;
    }

    @Override
    public Director replaceConfig(Config ... configs) {
        Map<Key<?>, List<Configuration>> localConfigurations = LOCAL_CONFIGURATIONS.get();
        DirectorImpl.setupConfig(localConfigurations, Occasion.REPLACING, configs);
        LOCAL_CONFIGURATIONS.set(localConfigurations);
        return this;
    }

    private <T, K> InternalCallableBinder<T, K> getBinder(T target, K ... inputs) {
        List<Configuration> configurations = this.getLocalConfigurations(target);
        InstanceBinderBuilder<T, K> builder = new InstanceBinderBuilder<T, K>(configurations, target, inputs);
        builder.build();
        return builder.getInstanceBinder().getCallableBinder(target, inputs);
    }

    private <T> List<Configuration> getLocalConfigurations(T target) {
        Key key = KeyGen.getKey(target.getClass());
        return LOCAL_CONFIGURATIONS.get().get(key);
    }

    private static <T, K> void validateTargetAndInputs(T target, K ... inputs) {
        DirectorImpl.checkNotNull(target, inputs);
        ClassChecker.checkInstanceType(target);
        DirectorImpl.checkInputInstanceTypes(inputs);
    }

    private static <T, K> void validateTargetAndInputs(Class<T> target, K ... inputs) {
        DirectorImpl.checkNotNull(target, inputs);
        ClassChecker.checkClassType(target);
        DirectorImpl.checkInputInstanceTypes(inputs);
    }

    private static <T, K> void checkNotNull(T target, K ... inputs) {
        ConditionUtil.verifyNotNull(target, (String)"The target instance is null.");
        for (K input : inputs) {
            ConditionUtil.verifyNotNull(input, (String)"One of the input instances is null.");
        }
    }

    private static void checkInputInstanceTypes(Object ... inputs) {
        if (ConditionUtil.isNotNull((Object)inputs) && inputs.length > 0) {
            for (Object input : inputs) {
                ClassChecker.checkInstanceType(input);
            }
        } else {
            throw new IllegalArgumentException("The input objects must need at least one instance.");
        }
    }

    private static enum Occasion {
        INITIALIZING,
        REPLACING;

    }
}

