/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.maru.core.Key;
import org.maru.core.KeyGen;
import org.maru.core.util.ConditionUtil;
import org.maru.core.util.StringUtil;
import org.maru.dog.DefinitionException;
import org.maru.dog.annotation.Bound;
import org.maru.dog.annotation.From;
import org.maru.dog.bind.BindingDefinition;
import org.maru.dog.bind.BindingDefinitionImpl;
import org.maru.dog.bind.TargetMarkedPoint;
import org.maru.dog.core.AbstractMarkedPointBuilder;
import org.maru.dog.util.MethodUtil;

final class TargetMarkedPointBuilder<T>
extends AbstractMarkedPointBuilder<T> {
    TargetMarkedPointBuilder(Class<T> type) {
        super(type, new BindingDefinitionImpl<T>(type));
    }

    @Override
    public void makeMarkedPoint(Member member) {
        TargetMarkedPoint<T> markedPoint = TargetMarkedPointBuilder.getTargetMarkedPoint(member, this.target);
        if (ConditionUtil.isNotNull(markedPoint)) {
            String keyName = markedPoint.getName();
            Key key = KeyGen.getKey((Object)keyName);
            ((BindingDefinition)this.definition).putMarkedPoint(key, markedPoint);
        }
    }

    private static <T> TargetMarkedPoint<T> getTargetMarkedPoint(Member member, Class<T> target) {
        Method m;
        Bound bound;
        TargetMarkedPoint<T> markedPoint = null;
        if (member instanceof Field) {
            Field f = (Field)member;
            bound = f.getAnnotation(Bound.class);
            String keyName = f.getName();
            if (bound != null) {
                if (StringUtil.isNotEmpty((String)bound.name())) {
                    keyName = bound.name();
                }
            } else {
                return null;
            }
            Class<?> inputClass = null;
            From from = f.getAnnotation(From.class);
            if (from != null) {
                inputClass = from.value();
            }
            markedPoint = TargetMarkedPointBuilder.createTargetMarkedPointInstance(target, keyName, f, inputClass);
        }
        if (member instanceof Method && (bound = (m = (Method)member).getAnnotation(Bound.class)) != null) {
            String methodName = m.getName();
            if (MethodUtil.isSetterMethod(methodName, m)) {
                String keyName = null;
                keyName = StringUtil.isNotEmpty((String)bound.name()) ? bound.name() : TargetMarkedPointBuilder.canonicalizeMethodName(methodName);
                if (StringUtil.isEmpty((String)keyName)) {
                    throw new IllegalArgumentException("Fail to make bound identifier. It might not be set the bound name, or setter method name is illegal style");
                }
                Class<?> inputClass = null;
                From from = m.getAnnotation(From.class);
                if (from != null) {
                    inputClass = from.value();
                }
                markedPoint = TargetMarkedPointBuilder.createTargetMarkedPointInstance(target, keyName, m, inputClass);
            } else {
                throw new DefinitionException(m.getName() + " method is not setter method following JavaBeans.");
            }
        }
        return markedPoint;
    }

    private static <T> TargetMarkedPoint<T> createTargetMarkedPointInstance(Class<T> target, String name, Member member, Class<?> inputClass) {
        return new TargetMarkedPoint<T>(target, name, member, inputClass);
    }
}

