/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maru.core.Key;
import org.maru.core.KeyGen;
import org.maru.core.type.GenericClassType;
import org.maru.core.type.PrimitiveWrapperTypes;
import org.maru.core.util.ConditionUtil;
import org.maru.dog.bind.AccessorMethodBinder;
import org.maru.dog.bind.BindingConfiguration;
import org.maru.dog.bind.BindingContext;
import org.maru.dog.bind.BindingDefinition;
import org.maru.dog.bind.BindingDefinitionCache;
import org.maru.dog.bind.FieldBinder;
import org.maru.dog.bind.InputMarkedPoint;
import org.maru.dog.bind.InputMarkedPointBuilder;
import org.maru.dog.bind.InstanceBinder;
import org.maru.dog.bind.InstanceBinderImpl;
import org.maru.dog.bind.MemberBinder;
import org.maru.dog.bind.TargetMarkedPoint;
import org.maru.dog.bind.TargetMarkedPointBuilder;
import org.maru.dog.core.Builder;
import org.maru.dog.core.Configuration;
import org.maru.dog.core.Definition;
import org.maru.dog.core.MarkedPoint;

public final class InstanceBinderBuilder<T, K>
implements Builder {
    private final T target;
    private final K[] inputs;
    private final List<Configuration> configurations;
    private final InstanceBinder<T, K> instanceBinder;

    public InstanceBinderBuilder(List<Configuration> configurations, T target, K ... inputs) {
        this.target = target;
        this.inputs = inputs;
        this.configurations = configurations;
        Class<?> targetType = target.getClass();
        Key targetKey = KeyGen.getKey(targetType);
        this.instanceBinder = new InstanceBinderImpl(targetKey, targetType);
    }

    @Override
    public Builder build() {
        Map<Key<?>, Definition<K>> inputDefinitions = this.buildInputMarkedPoints();
        Definition<T> targetDefinition = this.buildTargetMarkedPoints();
        this.validateAndCreateInstanceBinder(targetDefinition, inputDefinitions);
        return this;
    }

    public InstanceBinder<T, K> getInstanceBinder() {
        return this.instanceBinder;
    }

    private Map<Key<?>, Definition<K>> buildInputMarkedPoints() {
        HashMap definitions = new HashMap();
        for (K input : this.inputs) {
            Class<?> inputClass = input.getClass();
            if (PrimitiveWrapperTypes.isPrimitiveOrWrapperType(inputClass)) continue;
            Key key = KeyGen.getKey(inputClass);
            if (!BindingDefinitionCache.containsInputDefinition(key)) {
                InputMarkedPointBuilder builder = new InputMarkedPointBuilder(inputClass);
                builder.build();
                BindingDefinitionCache.applyInputDefinition(key, builder.getDefinition());
                if (definitions.containsKey(key)) continue;
                definitions.put(key, builder.getDefinition());
                continue;
            }
            Definition<?> definition = BindingDefinitionCache.getInputDefinition(key);
            definitions.put(key, definition);
        }
        return definitions;
    }

    private Definition<T> buildTargetMarkedPoints() {
        Key key = KeyGen.getKey(this.target.getClass());
        Definition<Object> definition = null;
        Class<?> targetType = this.target.getClass();
        if (!BindingDefinitionCache.containsTargetDefinition(key)) {
            TargetMarkedPointBuilder builder = new TargetMarkedPointBuilder(targetType);
            builder.build();
            definition = builder.getDefinition();
            BindingDefinitionCache.applyTargetDefinition(key, definition);
        } else {
            definition = BindingDefinitionCache.getTargetDefinition(key);
        }
        return definition;
    }

    private void validateAndCreateInstanceBinder(Definition<T> targetDefinition, Map<Key<?>, Definition<K>> inputDefinitions) {
        Key targetTypeKey = KeyGen.getKey(targetDefinition.getType());
        for (Map.Entry entry : ((BindingDefinition)targetDefinition).getMarkedPoints().entrySet()) {
            Key targetBoundKey = entry.getKey();
            TargetMarkedPoint targetMarkedPoint = (TargetMarkedPoint)entry.getValue();
            Class<?> inputClass = null;
            BindingConfiguration bindingConfiguration = this.searchBindingConfiguration(targetTypeKey, targetBoundKey);
            if (ConditionUtil.isNotNull((Object)bindingConfiguration)) {
                inputClass = bindingConfiguration.getInputClass();
                Key bindKey = ConditionUtil.isNotNull((Object)bindingConfiguration.getBindName()) ? KeyGen.getKey((Object)bindingConfiguration.getBindName()) : targetBoundKey;
                BindingContext<T, K> context = InstanceBinderBuilder.createBindingContext(targetMarkedPoint, bindKey, inputDefinitions, inputClass, bindingConfiguration);
                if (!ConditionUtil.isNotNull(context)) continue;
                MemberBinder<T, K> memberBinder = InstanceBinderBuilder.createMemberBinder(context);
                this.instanceBinder.addMemberBinder(memberBinder);
                continue;
            }
            inputClass = targetMarkedPoint.getInputClass();
            BindingContext<T, K> context = InstanceBinderBuilder.createBindingContext(targetMarkedPoint, targetBoundKey, inputDefinitions, inputClass, null);
            if (!ConditionUtil.isNotNull(context)) continue;
            MemberBinder<T, K> memberBinder = InstanceBinderBuilder.createMemberBinder(context);
            this.instanceBinder.addMemberBinder(memberBinder);
        }
    }

    private BindingConfiguration searchBindingConfiguration(Key<?> targetTypeKey, Key<?> targetBoundKey) {
        BindingConfiguration configuration = null;
        if (ConditionUtil.isNotNull(this.configurations) && this.configurations.size() > 0) {
            for (Configuration c : this.configurations) {
                Key configKey = KeyGen.getKey((Object)((BindingConfiguration)c).getBoundName());
                if (!targetBoundKey.equals((Object)configKey)) continue;
                configuration = (BindingConfiguration)c;
                break;
            }
        }
        return configuration;
    }

    private static <T, K> MemberBinder<T, K> createMemberBinder(BindingContext<T, K> context) {
        Member member = context.getTargetMarkedPoint().getMember();
        if (member instanceof Field) {
            return new FieldBinder<T, K>(context);
        }
        if (member instanceof Method) {
            return new AccessorMethodBinder<T, K>(context);
        }
        throw new IllegalArgumentException("Fails to solve the field or method binder.");
    }

    private static <T, K> BindingContext<T, K> createBindingContext(TargetMarkedPoint<T> targetMarkedPoint, Key<?> targetBoundKey, Map<Key<?>, Definition<K>> inputDefinitions, Class<?> inputClass, BindingConfiguration configuration) {
        BindingContext bindingContext = null;
        if (ConditionUtil.isNotNull(inputClass)) {
            Definition<K> inputDefinition;
            Key inputClassKey = KeyGen.getKey(inputClass);
            if (inputDefinitions.containsKey(inputClassKey) && ((BindingDefinition)(inputDefinition = inputDefinitions.get(inputClassKey))).containsMarkedPoint(targetBoundKey)) {
                InputMarkedPoint inputMarkedPoint = (InputMarkedPoint)((BindingDefinition)inputDefinition).getMarkedPoint(targetBoundKey);
                InstanceBinderBuilder.verifyTypeSafe(inputMarkedPoint, targetMarkedPoint);
                bindingContext = new BindingContext(targetMarkedPoint, inputMarkedPoint, configuration);
            }
        } else {
            int duplicateCount = 0;
            MarkedPoint inputMarkedPoint = null;
            for (Map.Entry<Key<?>, Definition<K>> inputEntry : inputDefinitions.entrySet()) {
                for (Map.Entry definedEntry : ((BindingDefinition)inputEntry.getValue()).getMarkedPoints().entrySet()) {
                    InputMarkedPoint tmpInputMarkedPoint = (InputMarkedPoint)definedEntry.getValue();
                    if (!tmpInputMarkedPoint.getName().equals(targetMarkedPoint.getName())) continue;
                    if (duplicateCount == 0) {
                        inputMarkedPoint = tmpInputMarkedPoint;
                    }
                    ++duplicateCount;
                }
            }
            if (duplicateCount > 1) {
                throw new IllegalArgumentException("The name [" + inputMarkedPoint.getName() + "] is duplicate.");
            }
            if (duplicateCount == 1) {
                InstanceBinderBuilder.verifyTypeSafe(inputMarkedPoint, targetMarkedPoint);
                bindingContext = new BindingContext(targetMarkedPoint, inputMarkedPoint, configuration);
            }
        }
        return bindingContext;
    }

    private static void verifyTypeSafe(InputMarkedPoint<?> inputMarkedPoint, TargetMarkedPoint<?> targetMarkedPoint) {
        if (ConditionUtil.isNotNull(inputMarkedPoint.getConverterDef().converterClass)) {
            InstanceBinderBuilder.verifyTypeSafeWithConverter(inputMarkedPoint, targetMarkedPoint);
        } else {
            InstanceBinderBuilder.verifyTypeSafeWithNoConverter(inputMarkedPoint, targetMarkedPoint);
        }
    }

    private static void verifyTypeSafeWithConverter(InputMarkedPoint<?> inputMarkedPoint, TargetMarkedPoint<?> targetMarkedPoint) {
        GenericClassType inputType = InstanceBinderBuilder.getInputGenericClassType(inputMarkedPoint);
        Type convertedValueType = inputMarkedPoint.getConverterDef().convertedValueType;
        GenericClassType parameter = GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)convertedValueType) ? PrimitiveWrapperTypes.getWrapperType((Type)convertedValueType) : convertedValueType));
        Type returnValueType = inputMarkedPoint.getConverterDef().converterMethod.getGenericReturnType();
        GenericClassType returnType = GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)returnValueType) ? PrimitiveWrapperTypes.getWrapperType((Type)returnValueType) : returnValueType));
        GenericClassType targetType = InstanceBinderBuilder.getTargetGenericClassType(targetMarkedPoint);
        InstanceBinderBuilder.checkTypeSafe(inputType, parameter, returnType, targetType);
    }

    private static void verifyTypeSafeWithNoConverter(InputMarkedPoint<?> inputMarkedPoint, TargetMarkedPoint<?> targetMarkedPoint) {
        GenericClassType inputType = InstanceBinderBuilder.getInputGenericClassType(inputMarkedPoint);
        GenericClassType targetType = InstanceBinderBuilder.getTargetGenericClassType(targetMarkedPoint);
        InstanceBinderBuilder.checkTypeSafe(inputType, targetType);
    }

    private static GenericClassType getInputGenericClassType(MarkedPoint<?> markedPoint) {
        Method method;
        Field field;
        Type type;
        GenericClassType genericClassType = markedPoint.getMember() instanceof Field ? GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)(type = (field = (Field)markedPoint.getMember()).getGenericType())) ? PrimitiveWrapperTypes.getWrapperType((Type)type) : type)) : GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)(type = (method = (Method)markedPoint.getMember()).getGenericReturnType())) ? PrimitiveWrapperTypes.getWrapperType((Type)type) : type));
        return genericClassType;
    }

    private static GenericClassType getTargetGenericClassType(MarkedPoint<?> markedPoint) {
        Method method;
        Field field;
        Type type;
        GenericClassType genericClassType = markedPoint.getMember() instanceof Field ? GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)(type = (field = (Field)markedPoint.getMember()).getGenericType())) ? PrimitiveWrapperTypes.getWrapperType((Type)type) : type)) : GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)(type = (method = (Method)markedPoint.getMember()).getGenericParameterTypes()[0])) ? PrimitiveWrapperTypes.getWrapperType((Type)type) : type));
        return genericClassType;
    }

    private static void checkTypeSafe(GenericClassType inputType, GenericClassType parameter, GenericClassType returnType, GenericClassType targetType) {
        if (!inputType.equals((Object)parameter) || !targetType.equals((Object)returnType)) {
            throw new IllegalArgumentException("The inpout type [" + inputType.getType() + "] and the parameter type on converter method [" + parameter.getType() + "], the target type [" + targetType.getType() + "] and the return type on converter method [" + returnType.getType() + "] are not type safe.");
        }
    }

    private static void checkTypeSafe(GenericClassType inputType, GenericClassType targetType) {
        if (!inputType.equals((Object)targetType)) {
            throw new IllegalArgumentException("The input type [" + inputType.getType() + " and the target type [" + targetType.getType() + "] are not type safe.");
        }
    }
}

