/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.maru.core.Key;
import org.maru.core.KeyGen;
import org.maru.core.annotation.Execute;
import org.maru.core.reflection.Clazz;
import org.maru.core.type.GenericClassType;
import org.maru.core.util.ConditionUtil;
import org.maru.core.util.StringUtil;
import org.maru.dog.DefinitionException;
import org.maru.dog.annotation.Bind;
import org.maru.dog.bind.BindingDefinition;
import org.maru.dog.bind.BindingDefinitionImpl;
import org.maru.dog.bind.ConverterDef;
import org.maru.dog.bind.InputMarkedPoint;
import org.maru.dog.converter.Converter;
import org.maru.dog.converter.ConverterIdentifier;
import org.maru.dog.core.AbstractMarkedPointBuilder;
import org.maru.dog.util.MethodUtil;

final class InputMarkedPointBuilder<T>
extends AbstractMarkedPointBuilder<T> {
    InputMarkedPointBuilder(Class<T> type) {
        super(type, new BindingDefinitionImpl<T>(type));
    }

    @Override
    public void makeMarkedPoint(Member member) {
        InputMarkedPoint<T> inputMarkedPoint = InputMarkedPointBuilder.getInputMarkedPoint(member, this.target);
        if (ConditionUtil.isNotNull(inputMarkedPoint)) {
            String keyName = inputMarkedPoint.getName();
            Key key = KeyGen.getKey((Object)keyName);
            ((BindingDefinition)this.definition).putMarkedPoint(key, inputMarkedPoint);
        }
    }

    private static <T> InputMarkedPoint<T> getInputMarkedPoint(Member member, Class<T> target) {
        InputMarkedPoint<T> inputMarkedPoint = null;
        if (member instanceof Field) {
            Field f = (Field)member;
            Bind bind = f.getAnnotation(Bind.class);
            String keyName = f.getName();
            if (bind != null) {
                if (StringUtil.isNotEmpty((String)bind.name())) {
                    keyName = bind.name();
                }
            } else {
                return null;
            }
            Annotation converterAnnotation = InputMarkedPointBuilder.checkAndGetConverterClassAnnotation(f);
            ConverterDef converterDef = new ConverterDef();
            if (converterAnnotation != null) {
                converterDef = InputMarkedPointBuilder.getConverterClassInformation(converterAnnotation, f.getGenericType());
                converterDef.verifyConverter();
            }
            inputMarkedPoint = InputMarkedPointBuilder.createInputMarkedPointInstance(target, keyName, f, converterDef);
            return inputMarkedPoint;
        }
        Method m = (Method)member;
        Bind bind = m.getAnnotation(Bind.class);
        if (bind != null) {
            String methodName = m.getName();
            if (MethodUtil.isGetterMethod(methodName, m)) {
                String keyName = null;
                keyName = StringUtil.isNotEmpty((String)bind.name()) ? bind.name() : InputMarkedPointBuilder.canonicalizeMethodName(methodName);
                if (StringUtil.isEmpty((String)keyName)) {
                    throw new IllegalArgumentException("Fail to make bind identifier. It might not be set the bind name, or gettter method name is illegal style");
                }
                Annotation converterAnnotation = InputMarkedPointBuilder.checkAndGetConverterClassAnnotation(m);
                ConverterDef converterDef = new ConverterDef();
                if (converterAnnotation != null) {
                    converterDef = InputMarkedPointBuilder.getConverterClassInformation(converterAnnotation, m.getGenericReturnType());
                    converterDef.verifyConverter();
                }
                inputMarkedPoint = InputMarkedPointBuilder.createInputMarkedPointInstance(target, keyName, m, converterDef);
            } else {
                throw new DefinitionException(m.getName() + " method is not getter method following JavaBeans.");
            }
        }
        return inputMarkedPoint;
    }

    private static <T> InputMarkedPoint<T> createInputMarkedPointInstance(Class<T> target, String name, Member member, ConverterDef converterDef) {
        return new InputMarkedPoint<T>(target, name, member, converterDef);
    }

    private static ConverterDef getConverterClassInformation(Annotation converterAnnotation, Type type) {
        ConverterDef converterDef = new ConverterDef();
        if (converterAnnotation instanceof Converter) {
            Converter converter = (Converter)converterAnnotation;
            if (converter != null) {
                converterDef.converterClass = converter.converterClass();
                String executeIdentifier = converter.execute();
                converterDef.converterMethod = InputMarkedPointBuilder.checkAndGetConverterClassMethod(executeIdentifier, converterDef.converterClass, GenericClassType.getClassFromType((Type)type));
            }
        } else {
            ConverterIdentifier converterIdentifier = converterAnnotation.annotationType().getAnnotation(ConverterIdentifier.class);
            converterDef.converterClass = converterIdentifier.value();
            converterDef.converterMethod = InputMarkedPointBuilder.checkAndGetConverterMethod(converterAnnotation, converterDef.converterClass, type);
        }
        converterDef.converterAnnotation = converterAnnotation;
        return converterDef;
    }

    private static Method checkAndGetConverterClassMethod(String executeIdentifier, Class<?> converterClass, Class<?> type) {
        Method method = null;
        if (StringUtil.isNotEmpty((String)executeIdentifier)) {
            int duplicatingCount = 0;
            for (Method m : converterClass.getDeclaredMethods()) {
                Execute execute = m.getAnnotation(Execute.class);
                if (!ConditionUtil.isNotNull((Object)execute) || !execute.value().equals(executeIdentifier) && !m.getName().equals(executeIdentifier)) continue;
                method = m;
                ++duplicatingCount;
            }
            if (duplicatingCount > 1) {
                throw new DefinitionException("[" + executeIdentifier + "] The name of executing identifier is duplicate.");
            }
        } else {
            method = Clazz.getDeclaredMethod(converterClass, (String)"execute", (Class[])new Class[]{type});
        }
        if (InputMarkedPointBuilder.checkSimpleConverterMethodDefinition(method)) {
            return method;
        }
        throw new DefinitionException("The Definition of simple convert class [" + converterClass.getName() + "] is invalid.");
    }

    private static boolean checkSimpleConverterMethodDefinition(Method method) {
        return ConditionUtil.isNotNull((Object)method) && !method.getGenericReturnType().equals(Void.TYPE) && method.getGenericParameterTypes().length == 1;
    }

    private static Annotation checkAndGetConverterClassAnnotation(Member member) {
        int number = 0;
        Annotation converterAnnotation = null;
        if (member instanceof Field) {
            Field field = (Field)member;
            for (Annotation annotation : field.getAnnotations()) {
                if (!InputMarkedPointBuilder.isConverterAnnotation(annotation)) continue;
                converterAnnotation = annotation;
                ++number;
            }
        } else if (member instanceof Method) {
            Method method = (Method)member;
            for (Annotation annotation : method.getAnnotations()) {
                if (!InputMarkedPointBuilder.isConverterAnnotation(annotation)) continue;
                converterAnnotation = annotation;
                ++number;
            }
        }
        if (number > 1) {
            throw new IllegalArgumentException("Two converter annotations are specified on one attribute");
        }
        return converterAnnotation;
    }

    private static boolean isConverterAnnotation(Annotation annotation) {
        if (annotation instanceof Converter) {
            return true;
        }
        ConverterIdentifier converterIdentifier = annotation.annotationType().getAnnotation(ConverterIdentifier.class);
        return ConditionUtil.isNotNull((Object)converterIdentifier);
    }

    private static Method checkAndGetConverterMethod(Annotation converterAnnotation, Class<?> converterClass, Type type) {
        int count = 0;
        Method converterMethod = null;
        for (Method method : converterClass.getDeclaredMethods()) {
            ConverterIdentifier converterIdentifier = method.getAnnotation(ConverterIdentifier.class);
            if (converterIdentifier == null || !converterIdentifier.value().equals(converterAnnotation.annotationType())) continue;
            converterMethod = method;
            ++count;
        }
        if (count > 1) {
            throw new IllegalArgumentException(converterAnnotation.annotationType().getName() + " is not unique on the " + converterClass.getName());
        }
        if (ConditionUtil.isNotNull(converterMethod) && !converterMethod.getGenericReturnType().equals(Void.TYPE) && converterMethod.getGenericParameterTypes().length >= 1) {
            return converterMethod;
        }
        throw new DefinitionException("The Definition of the extended convert class [" + converterClass.getName() + "] is invalid.");
    }
}

