/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.maru.core.Key;
import org.maru.core.KeyGen;
import org.maru.core.annotation.Value;
import org.maru.core.reflection.Clazz;
import org.maru.core.reflection.Fields;
import org.maru.core.reflection.Methods;
import org.maru.core.util.ConditionUtil;
import org.maru.dog.bind.BindingConfiguration;
import org.maru.dog.bind.BindingContext;
import org.maru.dog.bind.BindingFactory;
import org.maru.dog.bind.ConverterCache;
import org.maru.dog.bind.InputMarkedPoint;
import org.maru.dog.core.ObjectFactory;

final class BindingFactoryImpl
implements BindingFactory {
    BindingFactoryImpl() {
    }

    @Override
    public <T, K> Object get(BindingContext<T, K> context, K input) {
        int valuePosition;
        boolean converterOff = false;
        Member inputMember = context.getInputMarkedPoint().getMember();
        InputMarkedPoint<K> inputMarkedPoint = context.getInputMarkedPoint();
        BindingConfiguration configuration = context.getConfiguration();
        if (ConditionUtil.isNotNull((Object)configuration)) {
            converterOff = configuration.isConverterOff();
        }
        List<Object> inputObjects = !converterOff ? this.getInputObjects(inputMarkedPoint) : new ArrayList();
        Object object = null;
        if (inputMember instanceof Field) {
            Field inputField = (Field)inputMember;
            object = Fields.get((Field)inputField, input);
        }
        if (inputMember instanceof Method) {
            Method inputMethod = (Method)inputMember;
            object = Methods.invoke((Method)inputMethod, input, null);
        }
        if ((valuePosition = context.getInputMarkedPoint().getConverterDef().identifierParameters.indexOf(KeyGen.getKey(Value.class))) < 0) {
            inputObjects.add(object);
        } else {
            inputObjects.add(valuePosition, object);
        }
        Object convertedValue = !converterOff ? this.getConvertedValue(inputMarkedPoint, inputObjects) : null;
        return convertedValue != null ? convertedValue : object;
    }

    private List<Object> getInputObjects(InputMarkedPoint<?> inputMarkedPoint) {
        ArrayList<Object> inputObjects = new ArrayList<Object>();
        Annotation converterAnnotation = inputMarkedPoint.getConverterDef().converterAnnotation;
        for (Key<?> attributeKey : inputMarkedPoint.getConverterDef().identifierParameters) {
            if (!attributeKey.getType().equals(String.class)) continue;
            String attribute = (String)attributeKey.getInstance();
            Method m = Clazz.getDeclaredMethod(converterAnnotation.annotationType(), (String)attribute, null);
            Object value = Methods.invoke((Method)m, (Object)converterAnnotation, null);
            inputObjects.add(value);
        }
        return inputObjects;
    }

    private <K> Object getConvertedValue(InputMarkedPoint<K> inputMarkedPoint, List<Object> inputObjects) {
        Object convertedValue = null;
        Class<?> converterClass = inputMarkedPoint.getConverterDef().converterClass;
        Method converterMethod = inputMarkedPoint.getConverterDef().converterMethod;
        if (ConditionUtil.isNotNull(converterClass) && ConditionUtil.isNotNull((Object)converterMethod)) {
            Object[] inputObjectArray = inputObjects.toArray();
            Key converterKey = KeyGen.getKey(converterClass);
            Object converter = ObjectFactory.newInstance(converterClass);
            ConverterCache.apply(converterKey, converter);
            convertedValue = Methods.invoke((Method)converterMethod, converter, (Object[])inputObjectArray);
        }
        return convertedValue;
    }
}

