/*
 * Decompiled with CFR 0.152.
 */
package org.maru.core.type;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.maru.core.type.WrappedClass;
import org.maru.core.type.WrappedGenericArrayType;
import org.maru.core.type.WrappedParameterizedType;
import org.maru.core.type.WrappedTypeVariable;
import org.maru.core.type.WrappedWildcardType;

public class GenericClassType
implements Type,
Serializable {
    private static final long serialVersionUID = -5400526810102785412L;
    private Type type;

    public GenericClassType() {
    }

    public GenericClassType(Type type) {
        this.type = GenericClassType.getWrappedType(type);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static GenericClassType getGenericClassType(Type type) {
        return new GenericClassType(type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public static Class<?> getClassFromType(Type type) {
        if (type instanceof Class) {
            return WrappedClass.getClassFromType(type);
        }
        if (type instanceof ParameterizedType) {
            return WrappedParameterizedType.getClassFromType(type);
        }
        if (type instanceof GenericArrayType) {
            return WrappedGenericArrayType.getClassFromType(type);
        }
        if (type instanceof TypeVariable) {
            return WrappedTypeVariable.getClassFromType((TypeVariable)type);
        }
        throw new IllegalArgumentException("Unexpected type : " + type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericClassType other = (GenericClassType)obj;
        if (this.type == null) {
            if (other.type != null) {
                return false;
            }
        } else {
            if (this.type instanceof WrappedClass && other.type instanceof WrappedClass) {
                WrappedClass type1 = (WrappedClass)this.type;
                WrappedClass type2 = (WrappedClass)other.type;
                return type1.equals(type2);
            }
            if (this.type instanceof WrappedParameterizedType && other.type instanceof WrappedParameterizedType) {
                WrappedParameterizedType type1 = (WrappedParameterizedType)this.type;
                WrappedParameterizedType type2 = (WrappedParameterizedType)other.type;
                return type1.equals(type2);
            }
            if (this.type instanceof WrappedWildcardType && other.type instanceof WrappedWildcardType) {
                WrappedWildcardType type1 = (WrappedWildcardType)this.type;
                WrappedWildcardType type2 = (WrappedWildcardType)other.type;
                return type1.equals(type2);
            }
            if (this.type instanceof WrappedGenericArrayType && other.type instanceof WrappedGenericArrayType) {
                WrappedGenericArrayType type1 = (WrappedGenericArrayType)this.type;
                WrappedGenericArrayType type2 = (WrappedGenericArrayType)other.type;
                return type1.equals(type2);
            }
            if (this.type instanceof WrappedTypeVariable && other.type instanceof WrappedTypeVariable) {
                WrappedTypeVariable type1 = (WrappedTypeVariable)this.type;
                WrappedTypeVariable type2 = (WrappedTypeVariable)other.type;
                return type1.equals(type2);
            }
            if (this.type.equals(other.type)) {
                return true;
            }
        }
        return false;
    }

    public static Type getWrappedType(Type type) {
        if (type instanceof Class) {
            return new WrappedClass(type);
        }
        if (type instanceof ParameterizedType) {
            return new WrappedParameterizedType((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return new WrappedWildcardType((WildcardType)type);
        }
        if (type instanceof GenericArrayType) {
            return new WrappedGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return new WrappedTypeVariable((TypeVariable)type);
        }
        return type;
    }

    public static GenericClassType[] getGenericClassTypes(Type[] types) {
        GenericClassType[] genericClassTypes = new GenericClassType[types.length];
        for (int i = 0; i < types.length; ++i) {
            genericClassTypes[i] = GenericClassType.getGenericClassType(types[i]);
        }
        return genericClassTypes;
    }
}

