/*
 * Decompiled with CFR 0.152.
 */
package org.maru.core;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.maru.core.SoftReferences;
import org.maru.core.util.ConditionUtil;

public final class MapFactory {
    private MapFactory() {
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        return new ConcurrentSoftMap();
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity) {
        return new ConcurrentSoftMap(initialCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity, float loadFactor) {
        return new ConcurrentSoftMap(initialCapacity, loadFactor);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(Map<? extends K, SoftReferences<? extends V>> map) {
        return new ConcurrentSoftMap<K, V>(map);
    }

    public static ReferenceQueue<Object> getInternalQueue() {
        return InternalReferenceQueue.queue;
    }

    static class ReapableSoftValue<K, V>
    extends SoftReferences<V> {
        final ConcurrentMap<K, SoftReferences<V>> referentMap;
        final K key;

        public ReapableSoftValue(ConcurrentMap<K, SoftReferences<V>> referentMap, K key, V value, ReferenceQueue<Object> queue) {
            super(value, queue);
            this.key = key;
            this.referentMap = referentMap;
        }

        @Override
        public void reapReferent() {
            this.referentMap.remove(this.key);
        }
    }

    static class ConcurrentSoftMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V> {
        private final ConcurrentMap<K, SoftReferences<V>> map;
        private final transient ReferenceQueue<Object> queue = InternalReferenceQueue.queue;

        ConcurrentSoftMap() {
            this.map = new ConcurrentHashMap<K, SoftReferences<V>>();
        }

        ConcurrentSoftMap(int initialCapacity) {
            this.map = new ConcurrentHashMap<K, SoftReferences<V>>(initialCapacity);
        }

        ConcurrentSoftMap(int initialCapacity, float loadFactor) {
            this.map = new ConcurrentHashMap<K, SoftReferences<V>>(initialCapacity, loadFactor);
        }

        ConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            this.map = new ConcurrentHashMap<K, SoftReferences<V>>(initialCapacity, loadFactor, concurrencyLevel);
        }

        ConcurrentSoftMap(Map<? extends K, SoftReferences<? extends V>> m) {
            this.map = new ConcurrentHashMap<K, SoftReferences<SoftReferences<V>>>(m);
        }

        @Override
        public V put(K key, V value) {
            ReapableSoftValue<K, V> ref = new ReapableSoftValue<K, V>(this.map, key, value, this.queue);
            this.map.put(key, ref);
            return (V)ref.get();
        }

        @Override
        public V get(Object key) {
            Object value = null;
            SoftReferences softRef = (SoftReferences)this.map.get(key);
            if (ConditionUtil.isNotNull(softRef) && ConditionUtil.isNull(value = (Object)softRef.get())) {
                return null;
            }
            return (V)value;
        }

        @Override
        public V remove(Object key) {
            SoftReferences softRef = (SoftReferences)this.map.remove(key);
            if (ConditionUtil.isNull(softRef)) {
                return null;
            }
            return (V)softRef.get();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            SoftReferences ref = this.map.putIfAbsent(key, new ReapableSoftValue<K, V>(this.map, key, value, this.queue));
            if (ConditionUtil.isNotNull(ref) && ConditionUtil.isNotNull(ref.get())) {
                return (V)ref.get();
            }
            return value;
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.map.remove(key, new ReapableSoftValue<Object, Object>(this.map, key, value, this.queue));
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            return this.map.replace(key, new ReapableSoftValue<K, V>(this.map, key, oldValue, this.queue), new ReapableSoftValue<K, V>(this.map, key, newValue, this.queue));
        }

        @Override
        public V replace(K key, V value) {
            SoftReferences ref = this.map.replace(key, new ReapableSoftValue<K, V>(this.map, key, value, this.queue));
            return (V)ref.get();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
            for (final Map.Entry entry : this.map.entrySet()) {
                final Object value = ((SoftReferences)entry.getValue()).get();
                if (!ConditionUtil.isNotNull(value)) continue;
                entries.add(new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return entry.getKey();
                    }

                    @Override
                    public V getValue() {
                        return value;
                    }

                    @Override
                    public V setValue(V val) {
                        entry.setValue(new ReapableSoftValue(ConcurrentSoftMap.this.map, entry.getKey(), val, ConcurrentSoftMap.this.queue));
                        return val;
                    }
                });
            }
            return entries;
        }
    }

    static class InternalReferenceQueue {
        static final ReferenceQueue<Object> queue = new ReferenceQueue();

        InternalReferenceQueue() {
        }
    }
}

