/*
 * Decompiled with CFR 0.152.
 */
package org.maru.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.maru.core.Key;
import org.maru.core.util.ConditionUtil;

public final class KeyGen {
    private KeyGen() {
    }

    public static <T> Key<T> getKey(T value) {
        ConditionUtil.verifyNotNull(value);
        return new KeyImpl(value, (Composer)new ObjectComposer<T>(value));
    }

    public static <T> Key<T> getKey(Class<T> type) {
        ConditionUtil.verifyNotNull(type);
        if (Annotation.class.isAssignableFrom(type)) {
            return new KeyImpl(type, (Composer)new AnnotationTypeComposer(type));
        }
        return new KeyImpl(type, (Composer)new ClassComposer<T>(type));
    }

    public static <A extends Annotation> Key<A> getKey(A annotation) {
        ConditionUtil.verifyNotNull(annotation);
        return new KeyImpl(annotation, (Composer)new AnnotationComposer<A>(annotation));
    }

    static class KeyImpl<T>
    implements Key<T> {
        final Class<?> type;
        final int hashCode;
        T instance = null;
        Composer composer = null;
        ComposerType composerType = null;

        KeyImpl(Class<T> type, Composer compoer) {
            this.type = type;
            this.composer = compoer;
            this.composerType = KeyImpl.getComposerType(this.composer);
            this.hashCode = KeyImpl.calculateHashCode(this.type, this.composerType, this.composer);
        }

        KeyImpl(T value, Composer composer) {
            this.instance = value;
            this.type = value.getClass();
            this.composer = composer;
            this.composerType = KeyImpl.getComposerType(composer);
            this.hashCode = KeyImpl.calculateHashCode(this.type, this.composerType, this.composer);
        }

        <A extends Annotation> KeyImpl(A annotation, Composer composer) {
            this.type = annotation.annotationType();
            this.instance = annotation;
            this.composer = composer;
            this.composerType = KeyImpl.getComposerType(composer);
            this.hashCode = KeyImpl.calculateHashCode(this.type, this.composerType, composer);
        }

        private static ComposerType getComposerType(Composer composer) {
            if (composer instanceof ClassComposer) {
                return ComposerType.CLASS;
            }
            if (composer instanceof ObjectComposer) {
                return ComposerType.OBJECT;
            }
            if (composer instanceof AnnotationComposer) {
                return ComposerType.ANNOTATION;
            }
            if (composer instanceof AnnotationTypeComposer) {
                return ComposerType.ANNOTATION_TYPE;
            }
            throw new IllegalArgumentException("Unexpected composer : " + composer.getClass().getName());
        }

        private static int calculateHashCode(Class<?> type, ComposerType composerType, Composer composer) {
            if (composerType.equals((Object)ComposerType.CLASS)) {
                return type.hashCode() * 31 + composerType.hashCode();
            }
            if (composerType.equals((Object)ComposerType.OBJECT)) {
                return composer.hashCode() * 31 + composerType.hashCode();
            }
            if (composerType.equals((Object)ComposerType.ANNOTATION)) {
                return composer.hashCode() * 31 + composerType.hashCode();
            }
            if (composerType.equals((Object)ComposerType.ANNOTATION_TYPE)) {
                return composer.hashCode() * 31 + composerType.hashCode();
            }
            return 0;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyImpl other = (KeyImpl)obj;
            return this.composer.equals(other.composer) && this.composerType.equals((Object)other.composerType) && this.type.equals(other.type);
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Composer getComposer() {
            return this.composer;
        }

        @Override
        public T getInstance() {
            return this.instance;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("KeyImpl [");
            sb.append("composer=" + this.composer.toString() + ", ");
            sb.append("composerType=" + this.composerType.toString() + ", ");
            sb.append("hashCode=" + this.hashCode + ", ");
            sb.append("instance=" + this.instance + ", ");
            sb.append("type=" + this.type + "]");
            return sb.toString();
        }
    }

    static class AnnotationTypeComposer
    implements Composer {
        final Class<? extends Annotation> annotationType;

        AnnotationTypeComposer(Class<? extends Annotation> annotationType) {
            ConditionUtil.verifyNotNull(annotationType, "The annotation type is null");
            this.annotationType = annotationType;
        }

        public Class<? extends Annotation> getCompositeObject() {
            return this.annotationType;
        }

        @Override
        public Class<?> getType() {
            return this.annotationType;
        }

        public int hashCode() {
            return this.annotationType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AnnotationTypeComposer)) {
                return false;
            }
            AnnotationTypeComposer other = (AnnotationTypeComposer)obj;
            return !(this.annotationType == null ? other.annotationType != null : !this.annotationType.equals(other.annotationType));
        }

        public String toString() {
            return this.annotationType.toString();
        }

        @Override
        public Composer getTypeComposer() {
            return this;
        }
    }

    static class AnnotationComposer<A extends Annotation>
    implements Composer {
        final A annotation;

        AnnotationComposer(A annotation) {
            ConditionUtil.verifyNotNull(annotation, "The annotation is null");
            this.annotation = annotation;
        }

        public A getCompositeObject() {
            return this.annotation;
        }

        public Class<? extends Annotation> getType() {
            return this.annotation.annotationType();
        }

        public int hashCode() {
            return this.annotation.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AnnotationComposer)) {
                return false;
            }
            AnnotationComposer other = (AnnotationComposer)obj;
            if (this.annotation == null) {
                if (other.annotation != null) {
                    return false;
                }
            } else {
                if (this.annotation.annotationType() != other.annotation.annotationType()) {
                    return false;
                }
                if (!this.annotation.equals(other.annotation)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return this.annotation.toString();
        }

        @Override
        public Composer getTypeComposer() {
            return new AnnotationTypeComposer(this.annotation.annotationType());
        }
    }

    static class ClassComposer<T>
    implements Composer {
        final Class<T> type;

        ClassComposer(Class<T> type) {
            ConditionUtil.verifyNotNull(type, "The type is null");
            this.type = type;
        }

        public Class<T> getCompositeObject() {
            return this.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ClassComposer)) {
                return false;
            }
            ClassComposer other = (ClassComposer)obj;
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return this.type.toString();
        }

        public Class<T> getType() {
            return this.type;
        }

        @Override
        public Composer getTypeComposer() {
            return this;
        }
    }

    static class ObjectComposer<T>
    implements Composer {
        final T object;

        ObjectComposer(T object) {
            ConditionUtil.verifyNotNull(object, "The object is null");
            this.object = object;
        }

        @Override
        public T getCompositeObject() {
            return this.object;
        }

        public int hashCode() {
            return this.object != null ? this.object.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ObjectComposer)) {
                return false;
            }
            ObjectComposer other = (ObjectComposer)obj;
            if (this.object == null) {
                if (other.object != null) {
                    return false;
                }
            } else {
                if (this.object.getClass() != other.object.getClass()) {
                    return false;
                }
                if (!this.object.equals(other.object)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return this.object.toString();
        }

        @Override
        public Class<?> getType() {
            return this.object.getClass();
        }

        @Override
        public Composer getTypeComposer() {
            return new ClassComposer(this.object.getClass());
        }
    }

    static enum ComposerType {
        OBJECT,
        CLASS,
        ANNOTATION,
        ANNOTATION_TYPE;

    }

    public static interface Composer {
        public <T> T getCompositeObject();

        public Class<?> getType();

        public Composer getTypeComposer();
    }
}

