/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util;

import com.lavans.util.Config;
import com.lavans.util.Method;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class Logger {
    private static final String CLASSNAME = "com.lavans.util.Logger";
    private static String configFile = "lavansutil.xml";
    private static final String CONFIG_SECTION = "logger";
    public static final int ERR = 0;
    public static final int LOG = 1;
    public static final int TRACE = 2;
    public static final int DEBUG = 3;
    public static final int DEBUGTOOL = 4;
    private int logLevel = 0;
    public static final String SECONDLY = "secondly";
    public static final String MINUTELY = "minutely";
    public static final String HOURLY = "hourly";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";
    public static final String MONTHLY = "monthly";
    private int rotate_term = 5;
    private StringBuffer buf = new StringBuffer();
    private DateFormat time_format = null;
    private Calendar lastLog = null;
    private int rotate = 5;
    private String logfileName = null;
    private int max_indent_size = 80;
    private static Map instanceMap = new HashMap();
    private static final PrintWriter SYSTEM_WRITER = new PrintWriter(System.out, true);
    private PrintWriter log;
    private OutputStream fileOut;

    public static void main(String[] args) {
        Logger logger = Logger.getInstance();
        logger.log("LogTest:" + new Date().toString());
        logger.err("LogTest:" + new Date().toString());
        logger.debug("LogTest:" + new Date().toString());
    }

    public static void init(String filename) {
        configFile = filename;
    }

    private Logger(String configSection) {
        Element conf = (Element)Config.getInstance(configFile).getNode(configSection);
        if (conf == null) {
            System.out.println("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306b[" + configSection + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            this.time_format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            this.log = SYSTEM_WRITER;
            this.logLevel = 0;
            return;
        }
        String format = conf.getAttribute("time_format");
        if (format.equals("")) {
            format = "yyyy/MM/dd HH:mm:ss.SSS";
        }
        this.time_format = new SimpleDateFormat(format);
        this.logfileName = conf.getAttribute("file");
        if (this.logfileName.equals("System.out")) {
            this.log = SYSTEM_WRITER;
        } else {
            boolean isExistFile = new File(this.logfileName).exists();
            this.log = this.createWriter(this.logfileName);
            String term = conf.getAttribute("term");
            if (term == null || term.equals("")) {
                this.rotate_term = 5;
            } else if (SECONDLY.equals(term)) {
                this.rotate_term = 13;
            } else if (MINUTELY.equals(term)) {
                this.rotate_term = 12;
            } else if (HOURLY.equals(term)) {
                this.rotate_term = 11;
            } else if (WEEKLY.equals(term)) {
                this.rotate_term = 3;
            } else if (MONTHLY.equals(term)) {
                this.rotate_term = 2;
            }
            try {
                this.rotate = Integer.parseInt(conf.getAttribute("rotate"));
            }
            catch (Exception e) {
                this.debug("log rotate\u53d6\u5f97\u5931\u6557\u3002\u30c7\u30d5\u30a9\u30eb\u30c8" + this.rotate);
            }
            boolean isInitialRotate = false;
            try {
                isInitialRotate = Boolean.valueOf(conf.getAttribute("initial_rotate"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isInitialRotate && isExistFile) {
                this.rotate();
            }
        }
        this.lastLog = Calendar.getInstance();
        try {
            this.logLevel = Integer.parseInt(conf.getAttribute("level"));
        }
        catch (Exception e) {
            this.log.println(String.valueOf(this.timeFormat()) + "get [level] failed. level is set to TRACE");
            this.logLevel = 2;
        }
    }

    private PrintWriter createWriter(String logfile) {
        PrintWriter out = null;
        try {
            this.fileOut = new FileOutputStream(logfile, true);
            out = new PrintWriter(this.fileOut, true);
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't open logfile.[" + logfile + "] log is set to [System.out]");
            System.err.println(e.getMessage());
            out = SYSTEM_WRITER;
        }
        return out;
    }

    public void setStream(PrintStream out) {
        this.log = new PrintWriter(out);
    }

    public void setWriter(PrintWriter out) {
        this.log = out;
    }

    public PrintWriter getWriter() {
        return this.log;
    }

    public static Logger getInstance(String configSection) {
        Logger instance = (Logger)instanceMap.get(configSection);
        if (instance == null) {
            try {
                instance = new Logger(configSection);
                instanceMap.put(configSection, instance);
            }
            catch (Exception e) {
                System.out.println("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306b[" + configSection + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            }
        }
        return instance;
    }

    public static Logger getInstance() {
        return Logger.getInstance(CONFIG_SECTION);
    }

    private String timeFormat() {
        if (this.log == SYSTEM_WRITER) {
            return this.time_format.format(new Date());
        }
        Calendar now = Calendar.getInstance();
        if (now.get(this.rotate_term) != this.lastLog.get(this.rotate_term)) {
            System.out.println("rotate\u9593\u9694" + this.rotate_term + " now[" + now.get(this.rotate_term) + "] last[" + this.lastLog.get(this.rotate_term) + "]");
            this.rotate();
        }
        this.lastLog = now;
        return this.time_format.format(now.getTime());
    }

    private void rotate() {
        if (this.log == SYSTEM_WRITER) {
            return;
        }
        File file = new File(String.valueOf(this.logfileName) + "." + this.rotate);
        file.delete();
        int i = this.rotate;
        while (i > 1) {
            file = new File(String.valueOf(this.logfileName) + "." + (i - 1));
            file.renameTo(new File(String.valueOf(this.logfileName) + "." + i));
            --i;
        }
        this.log.close();
        try {
            this.fileOut.close();
        }
        catch (IOException e) {
            System.out.println("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u30af\u30ed\u30fc\u30ba\u5931\u6557.\n" + e.getMessage());
        }
        file = new File(this.logfileName);
        System.out.println(file.getPath());
        if (file.renameTo(new File(String.valueOf(this.logfileName) + ".1"))) {
            System.out.println("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0");
        } else {
            System.out.println("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u5931\u6557");
        }
        this.log = this.createWriter(this.logfileName);
    }

    public void err(String msg) {
        this.log.println(String.valueOf(this.timeFormat()) + " ERR  :" + this.buf + msg);
    }

    public void err(Exception e) {
        this.log.println(String.valueOf(this.timeFormat()) + " ERR  :" + this.buf + e.getMessage());
        e.printStackTrace(this.log);
    }

    public void log(String msg) {
        if (this.logLevel < 1) {
            return;
        }
        this.log.println(String.valueOf(this.timeFormat()) + " LOG  :" + this.buf + msg);
    }

    public void debug(byte[] msg) {
        if (this.logLevel < 3) {
            return;
        }
        this.log.println(String.valueOf(this.timeFormat()) + " DEBUG:" + this.buf + new String(msg));
    }

    public void debug(String msg) {
        if (this.logLevel < 3) {
            return;
        }
        StringBuffer dbuf = null;
        dbuf = msg == null ? new StringBuffer(34) : new StringBuffer(30 + msg.length());
        this.log.println(dbuf.append(this.timeFormat()).append(" DEBUG:").append(this.buf).append(msg));
    }

    public void debug(Exception e) {
        if (this.logLevel < 3) {
            return;
        }
        this.log.println(String.valueOf(this.timeFormat()) + " DEBUG:" + this.buf + e.getMessage());
        e.printStackTrace(this.log);
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (this.logLevel < 2) {
            return;
        }
        this.log.println(String.valueOf(this.timeFormat()) + " TRACE:" + this.buf + sourceClass + "#" + sourceMethod + "() ENTER");
        if (this.buf.length() < this.max_indent_size) {
            this.buf.append("  ");
        }
    }

    public void entering() {
        if (this.logLevel < 2) {
            return;
        }
        this.log.println(String.valueOf(this.timeFormat()) + " TRACE:" + this.buf + this.getMethodName() + " ENTER");
        if (this.buf.length() < this.max_indent_size) {
            this.buf.append("  ");
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (this.logLevel < 2) {
            return;
        }
        try {
            this.buf.delete(0, 2);
        }
        catch (Exception e) {
            this.buf = new StringBuffer();
        }
        this.log.println(String.valueOf(this.timeFormat()) + " TRACE:" + this.buf + sourceClass + "#" + sourceMethod + "() EXIT");
    }

    public void exiting() {
        if (this.logLevel < 2) {
            return;
        }
        try {
            this.buf.delete(0, 2);
        }
        catch (Exception e) {
            this.buf = new StringBuffer();
        }
        this.log.println(String.valueOf(this.timeFormat()) + " TRACE:" + this.buf + this.getMethodName() + " EXIT");
    }

    public void debugTool(String msg) {
        if (this.logLevel < 4) {
            return;
        }
        this.log.println(String.valueOf(this.timeFormat()) + " TOOLDEBUG:" + this.buf + msg);
    }

    public void enteringTool() {
        if (this.logLevel < 4) {
            return;
        }
        this.log.println(String.valueOf(this.timeFormat()) + " TOOLDEBUG:" + this.buf + Method.getMethodNameTool(CLASSNAME) + " ENTER");
        if (this.buf.length() < this.max_indent_size) {
            this.buf.append("  ");
        }
    }

    public void exitingTool() {
        if (this.logLevel < 4) {
            return;
        }
        try {
            this.buf.delete(0, 2);
        }
        catch (Exception e) {
            this.buf = new StringBuffer();
        }
        this.log.println(String.valueOf(this.timeFormat()) + " TOOLDEBUG:" + this.buf + Method.getMethodNameTool(CLASSNAME) + " EXIT");
    }

    public void log(int level, String msg) {
        switch (level) {
            case 0: {
                this.err(msg);
                break;
            }
            case 1: {
                this.log(msg);
                break;
            }
            case 3: {
                this.debug(msg);
                break;
            }
            case 4: {
                this.debugTool(msg);
                break;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.log.close();
        super.finalize();
    }

    private String getMethodName() {
        return Method.getMethodName(CLASSNAME);
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setTime_format(DateFormat time_format) {
        this.time_format = time_format;
    }

    public void deleteBuf(int i) {
        try {
            this.buf.delete(0, i);
        }
        catch (Exception e) {
            this.buf = new StringBuffer();
        }
    }
}

