/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.process;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.groupware.model.MToDo;
import jpiere.plugin.groupware.model.MToDoReminder;
import jpiere.plugin.groupware.util.GroupwareTeamUtil;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_NonBusinessDay;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CreateToDoRepeatedly
extends SvrProcess {
    private int p_JP_ToDo_ID = 0;
    private int p_JP_Offset_Value = 0;
    private String p_JP_Repetition_Interval = null;
    private Timestamp p_DateTo = null;
    private int p_JP_NonBusinessDayCalendar_ID = 0;
    private int p_C_Country_ID = 0;
    private String p_JP_NonBusinessDayToDoHandling = null;
    private boolean p_IsCopyReminderJP = false;
    private boolean p_IsScheduledStartDateEndOfMonth = false;
    private boolean p_IsScheduledEndDateEndOfMonth = false;
    private MToDo m_ToDo = null;
    private List<Long> diffList_RemindTime = new ArrayList<Long>();
    private Timestamp v_JP_ToDo_ScheduledStartTime = null;
    private Timestamp v_JP_ToDo_ScheduledEndTime = null;
    private MToDo v_ToDo = null;
    List<X_C_NonBusinessDay> list_NonBusinessDays = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_Offset_Value")) {
                    this.p_JP_Offset_Value = para[i].getParameterAsInt();
                } else if (name.equals("JP_Repetition_Interval")) {
                    this.p_JP_Repetition_Interval = para[i].getParameterAsString();
                } else if (name.equals("DateTo")) {
                    this.p_DateTo = para[i].getParameterAsTimestamp();
                } else if (name.equals("JP_NonBusinessDayCalendar_ID")) {
                    this.p_JP_NonBusinessDayCalendar_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Country_ID")) {
                    this.p_C_Country_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_NonBusinessDayToDoHandling")) {
                    this.p_JP_NonBusinessDayToDoHandling = para[i].getParameterAsString();
                } else if (name.equals("IsCopyReminderJP")) {
                    this.p_IsCopyReminderJP = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_JP_ToDo_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        LocalTime localTime;
        LocalDate endOfMonth;
        this.v_ToDo = this.m_ToDo = new MToDo(this.getCtx(), this.p_JP_ToDo_ID, this.get_TrxName());
        if ("M".equals(this.m_ToDo.getJP_ToDo_Type())) {
            if (this.getTable_ID() == 0) {
                return "JP_ToDo_Memo_CouldNotCreateRepeatedly";
            }
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToDo_Memo_CouldNotCreateRepeatedly"));
        }
        if (this.m_ToDo.getJP_ToDo_Team_ID() > 0) {
            if (this.getTable_ID() == 0) {
                return "JP_ToDo_NotCreatPersonalToDoFromTeamToDo";
            }
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToDo_NotCreatPersonalToDoFromTeamToDo"));
        }
        MToDoReminder[] reminders = this.m_ToDo.getReminders();
        Timestamp scheduledEndTime = null;
        Timestamp remindTime = null;
        int i = 0;
        while (i < reminders.length) {
            scheduledEndTime = this.m_ToDo.getJP_ToDo_ScheduledEndTime();
            remindTime = reminders[i].getJP_ToDo_RemindTime();
            this.diffList_RemindTime.add(scheduledEndTime.getTime() - remindTime.getTime());
            ++i;
        }
        if (this.p_JP_Repetition_Interval.equals("M")) {
            LocalDate localDate = this.m_ToDo.getJP_ToDo_ScheduledStartDate().toLocalDateTime().toLocalDate();
            if (localDate.compareTo(endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth())) == 0) {
                this.p_IsScheduledStartDateEndOfMonth = true;
            }
            if ((localDate = this.m_ToDo.getJP_ToDo_ScheduledEndDate().toLocalDateTime().toLocalDate()).compareTo(endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth())) == 0) {
                this.p_IsScheduledEndDateEndOfMonth = true;
            }
        }
        if (this.m_ToDo.getJP_Processing1().equals("Y")) {
            if (this.getTable_ID() == 0) {
                return "JP_ToDo_AlreadyCreatedRepeatedly";
            }
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToDo_AlreadyCreatedRepeatedly"));
        }
        this.v_JP_ToDo_ScheduledStartTime = this.calculateNextScheduleTime(this.m_ToDo.getJP_ToDo_ScheduledStartTime());
        if (this.p_IsScheduledStartDateEndOfMonth) {
            LocalDate localDate = this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalDate();
            endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
            localTime = this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalTime();
            this.v_JP_ToDo_ScheduledStartTime = Timestamp.valueOf(LocalDateTime.of(endOfMonth, localTime));
        }
        this.v_JP_ToDo_ScheduledEndTime = this.calculateNextScheduleTime(this.m_ToDo.getJP_ToDo_ScheduledEndTime());
        if (this.p_IsScheduledEndDateEndOfMonth) {
            LocalDate localDate = this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalDate();
            endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
            localTime = this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalTime();
            this.v_JP_ToDo_ScheduledEndTime = Timestamp.valueOf(LocalDateTime.of(endOfMonth, localTime));
        }
        this.p_DateTo = Timestamp.valueOf(LocalDateTime.of(this.p_DateTo.toLocalDateTime().toLocalDate(), LocalTime.MAX));
        while (this.p_DateTo.compareTo(this.v_JP_ToDo_ScheduledStartTime) >= 0) {
            this.createToDo();
            this.v_JP_ToDo_ScheduledStartTime = this.calculateNextScheduleTime(this.v_JP_ToDo_ScheduledStartTime);
            if (this.p_IsScheduledStartDateEndOfMonth) {
                LocalDate localDate = this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalDate();
                endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
                localTime = this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalTime();
                this.v_JP_ToDo_ScheduledStartTime = Timestamp.valueOf(LocalDateTime.of(endOfMonth, localTime));
            }
            this.v_JP_ToDo_ScheduledEndTime = this.calculateNextScheduleTime(this.v_JP_ToDo_ScheduledEndTime);
            if (!this.p_IsScheduledEndDateEndOfMonth) continue;
            LocalDate localDate = this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalDate();
            endOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
            localTime = this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalTime();
            this.v_JP_ToDo_ScheduledEndTime = Timestamp.valueOf(LocalDateTime.of(endOfMonth, localTime));
        }
        this.m_ToDo.setJP_Processing1("Y");
        this.m_ToDo.saveEx(this.get_TrxName());
        if (this.getTable_ID() == 0) {
            return "Success";
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private void createToDo() {
        Timestamp ts;
        boolean isNonBusinessDay;
        MToDo new_ToDo = new MToDo(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this.v_ToDo, (PO)new_ToDo);
        if ("S".equals(new_ToDo.getJP_ToDo_Type())) {
            if (Util.isEmpty((String)this.p_JP_NonBusinessDayToDoHandling) || this.p_JP_NonBusinessDayToDoHandling.equals("B")) {
                new_ToDo.setJP_ToDo_ScheduledStartDate(this.v_JP_ToDo_ScheduledStartTime);
                new_ToDo.setJP_ToDo_ScheduledStartTime(this.v_JP_ToDo_ScheduledStartTime);
            } else {
                isNonBusinessDay = this.checkNonBusinessDay(this.v_JP_ToDo_ScheduledStartTime.toLocalDateTime().toLocalDate());
                if (isNonBusinessDay) {
                    if (this.p_JP_NonBusinessDayToDoHandling.equals("A") || this.p_JP_Repetition_Interval.equals("D")) {
                        return;
                    }
                    if (this.p_JP_NonBusinessDayToDoHandling.equals("C")) {
                        ts = this.preDay(this.v_JP_ToDo_ScheduledStartTime);
                        new_ToDo.setJP_ToDo_ScheduledStartDate(ts);
                        new_ToDo.setJP_ToDo_ScheduledStartTime(ts);
                    } else if (this.p_JP_NonBusinessDayToDoHandling.equals("D")) {
                        ts = this.nextDay(this.v_JP_ToDo_ScheduledStartTime);
                        new_ToDo.setJP_ToDo_ScheduledStartDate(ts);
                        new_ToDo.setJP_ToDo_ScheduledStartTime(ts);
                    }
                } else {
                    new_ToDo.setJP_ToDo_ScheduledStartDate(this.v_JP_ToDo_ScheduledStartTime);
                    new_ToDo.setJP_ToDo_ScheduledStartTime(this.v_JP_ToDo_ScheduledStartTime);
                }
            }
        }
        if (Util.isEmpty((String)this.p_JP_NonBusinessDayToDoHandling)) {
            new_ToDo.setJP_ToDo_ScheduledEndDate(this.v_JP_ToDo_ScheduledEndTime);
            new_ToDo.setJP_ToDo_ScheduledEndTime(this.v_JP_ToDo_ScheduledEndTime);
        } else {
            isNonBusinessDay = this.checkNonBusinessDay(this.v_JP_ToDo_ScheduledEndTime.toLocalDateTime().toLocalDate());
            if (isNonBusinessDay) {
                if (this.p_JP_NonBusinessDayToDoHandling.equals("A") || this.p_JP_Repetition_Interval.equals("D")) {
                    return;
                }
                if (this.p_JP_NonBusinessDayToDoHandling.equals("C")) {
                    ts = this.preDay(this.v_JP_ToDo_ScheduledEndTime);
                    new_ToDo.setJP_ToDo_ScheduledEndDate(ts);
                    new_ToDo.setJP_ToDo_ScheduledEndTime(ts);
                } else if (this.p_JP_NonBusinessDayToDoHandling.equals("D")) {
                    ts = this.nextDay(this.v_JP_ToDo_ScheduledEndTime);
                    new_ToDo.setJP_ToDo_ScheduledEndDate(ts);
                    new_ToDo.setJP_ToDo_ScheduledEndTime(ts);
                }
            } else {
                new_ToDo.setJP_ToDo_ScheduledEndDate(this.v_JP_ToDo_ScheduledEndTime);
                new_ToDo.setJP_ToDo_ScheduledEndTime(this.v_JP_ToDo_ScheduledEndTime);
            }
        }
        if (new_ToDo.getJP_ToDo_ScheduledStartDate().compareTo(new_ToDo.getJP_ToDo_ScheduledEndDate()) > 0 || "T".equals(new_ToDo.getJP_ToDo_Type())) {
            new_ToDo.setJP_ToDo_ScheduledStartDate(this.v_JP_ToDo_ScheduledEndTime);
            new_ToDo.setJP_ToDo_ScheduledStartTime(this.v_JP_ToDo_ScheduledEndTime);
        }
        new_ToDo.setJP_ToDo_Related_ID(this.p_JP_ToDo_ID);
        new_ToDo.setJP_ToDo_Status("NY");
        new_ToDo.saveEx(this.get_TrxName());
        if (this.p_IsCopyReminderJP) {
            this.createToDoRemainder(new_ToDo);
        }
        this.v_ToDo = new_ToDo;
    }

    private void createToDoRemainder(MToDo new_ToDo) {
        MToDoReminder[] m_ToDoReminders = this.v_ToDo.getReminders();
        MToDoReminder tdr = null;
        Timestamp remindTime = null;
        int i = 0;
        while (i < m_ToDoReminders.length) {
            tdr = new MToDoReminder(this.getCtx(), 0, this.get_TrxName());
            tdr.setAD_Org_ID(0);
            tdr.setJP_ToDo_ID(new_ToDo.getJP_ToDo_ID());
            tdr.setJP_ToDo_ReminderType(m_ToDoReminders[i].getJP_ToDo_ReminderType());
            tdr.setDescription(m_ToDoReminders[i].getDescription());
            remindTime = new Timestamp(new_ToDo.getJP_ToDo_ScheduledEndTime().getTime() - this.diffList_RemindTime.get(i));
            tdr.setJP_ToDo_RemindTime(remindTime);
            tdr.setIsSentReminderJP(false);
            tdr.saveEx(this.get_TrxName());
            ++i;
        }
    }

    private Timestamp calculateNextScheduleTime(Timestamp timestamp) {
        return GroupwareTeamUtil.calculateNextScheduleTime(timestamp, this.p_JP_Offset_Value, this.p_JP_Repetition_Interval);
    }

    private boolean checkNonBusinessDay(LocalDate localDate) {
        if (this.list_NonBusinessDays == null) {
            StringBuilder whereClause = null;
            StringBuilder orderClause = null;
            ArrayList<Comparable<Integer>> list_parameters = new ArrayList<Comparable<Integer>>();
            Object[] parameters = null;
            LocalDateTime toDayMin = LocalDateTime.of(this.m_ToDo.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalDate(), LocalTime.MIN);
            LocalDateTime toDayMax = LocalDateTime.of(this.p_DateTo.toLocalDateTime().toLocalDate(), LocalTime.MAX);
            whereClause = new StringBuilder(" AD_Client_ID=? ");
            list_parameters.add(Integer.valueOf(Env.getAD_Client_ID((Properties)this.getCtx())));
            whereClause = whereClause.append(" AND C_Calendar_ID = ? ");
            list_parameters.add(Integer.valueOf(this.p_JP_NonBusinessDayCalendar_ID));
            whereClause = whereClause.append(" AND Date1 <= ? AND Date1 >= ? AND IsActive='Y' ");
            list_parameters.add(Timestamp.valueOf(toDayMax));
            list_parameters.add(Timestamp.valueOf(toDayMin));
            if (this.p_C_Country_ID == 0) {
                whereClause = whereClause.append(" AND C_Country_ID IS NULL ");
            } else {
                whereClause = whereClause.append(" AND ( C_Country_ID IS NULL OR C_Country_ID = ? ) ");
                list_parameters.add(Integer.valueOf(this.p_C_Country_ID));
            }
            parameters = list_parameters.toArray(new Object[list_parameters.size()]);
            orderClause = new StringBuilder("Date1");
            this.list_NonBusinessDays = new Query(Env.getCtx(), "C_NonBusinessDay", whereClause.toString(), null).setParameters(parameters).setOrderBy(orderClause.toString()).list();
        }
        boolean isNonBusinessDay = false;
        for (X_C_NonBusinessDay nonBusinessDay : this.list_NonBusinessDays) {
            if (nonBusinessDay.getDate1().toLocalDateTime().toLocalDate().compareTo(localDate) != 0) continue;
            isNonBusinessDay = true;
            break;
        }
        return isNonBusinessDay;
    }

    private Timestamp preDay(Timestamp timestamp) {
        LocalDate localDate = timestamp.toLocalDateTime().toLocalDate();
        LocalTime localTime = timestamp.toLocalDateTime().toLocalTime();
        boolean isNonBusinessDay = true;
        while (isNonBusinessDay) {
            localDate = localDate.minusDays(1L);
            isNonBusinessDay = this.checkNonBusinessDay(localDate);
        }
        return Timestamp.valueOf(LocalDateTime.of(localDate, localTime));
    }

    private Timestamp nextDay(Timestamp timestamp) {
        LocalDate localDate = timestamp.toLocalDateTime().toLocalDate();
        LocalTime localTime = timestamp.toLocalDateTime().toLocalTime();
        boolean isNonBusinessDay = true;
        while (isNonBusinessDay) {
            localDate = localDate.plusDays(1L);
            isNonBusinessDay = this.checkNonBusinessDay(localDate);
        }
        return Timestamp.valueOf(LocalDateTime.of(localDate, localTime));
    }
}

