/*
 * Decompiled with CFR 0.152.
 */
package com.iabcinc.mapping.voronoi;

import com.iabcinc.common.FlagableImpl;
import com.iabcinc.mapping.voronoi.Point;
import com.iabcinc.mapping.voronoi.RegionFilter;

public class QuadEdge
extends FlagableImpl {
    private int type;
    public static final int TYPE_ORIGINAL = 0;
    public static final int TYPE_ROTATED = 1;
    public static final int TYPE_SYMMETRIC = 2;
    public static final int TYPE_INVROT = 3;
    Point org = null;
    private QuadEdge next = null;
    private QuadEdge dual = null;

    protected QuadEdge(int type) {
        this.type = type;
    }

    public QuadEdge() {
        this(0);
        QuadEdge e0 = this;
        QuadEdge e1 = new QuadEdge(1);
        QuadEdge e2 = new QuadEdge(2);
        QuadEdge e3 = new QuadEdge(3);
        e0.setRot(e1);
        e1.setRot(e2);
        e2.setRot(e3);
        e3.setRot(e0);
        e0.setOnext(e0);
        e1.setOnext(e3);
        e2.setOnext(e2);
        e3.setOnext(e1);
    }

    public boolean isLeftRegionEdge(RegionFilter filter) {
        String lRegion = filter.getRegionName(this.invrot().getOrg());
        String rRegion = filter.getRegionName(this.rot().getOrg());
        boolean lOpen = this.invrot().getOrg().isFlagSet(1);
        boolean rOpen = this.rot().getOrg().isFlagSet(1);
        if (!lOpen && rOpen) {
            return true;
        }
        if (lOpen) {
            return false;
        }
        if (lRegion == null && rRegion != null || lRegion != null && rRegion == null) {
            return true;
        }
        if (lRegion == null && rRegion == null) {
            return false;
        }
        return !lRegion.equals(rRegion);
    }

    public boolean isRightRegionEdge(RegionFilter filter) {
        String lRegion = filter.getRegionName(this.invrot().getOrg());
        String rRegion = filter.getRegionName(this.rot().getOrg());
        boolean lOpen = this.invrot().getOrg().isFlagSet(1);
        boolean rOpen = this.rot().getOrg().isFlagSet(1);
        if (lOpen && !rOpen) {
            return true;
        }
        if (rOpen) {
            return false;
        }
        if (lRegion == null && rRegion != null || lRegion != null && rRegion == null) {
            return true;
        }
        if (lRegion == null && rRegion == null) {
            return false;
        }
        return !lRegion.equals(rRegion);
    }

    public void setOrg(Point pt) {
        this.org = pt;
    }

    public void setDest(Point pt) {
        this.dual.dual.setOrg(pt);
    }

    public void setRot(QuadEdge e) {
        this.dual = e;
    }

    public void setSym(QuadEdge e) {
        this.dual.dual = e;
    }

    public void setInvrot(QuadEdge e) {
        this.dual.dual.dual = e;
    }

    public void setOnext(QuadEdge e) {
        this.next = e;
    }

    public void setLnext(QuadEdge e) {
        this.dual.dual.dual.next.dual = e;
    }

    public void setOprev(QuadEdge e) {
        this.dual.next.dual = e;
    }

    public void setRnext(QuadEdge e) {
        this.dual.next.dual.dual.dual = e;
    }

    public Point getOrg() {
        return this.org;
    }

    public Point getDest() {
        return this.dual.dual.org;
    }

    public QuadEdge rot() {
        return this.dual;
    }

    public QuadEdge sym() {
        return this.dual.dual;
    }

    public QuadEdge invrot() {
        return this.dual.dual.dual;
    }

    public QuadEdge onext() {
        return this.next;
    }

    public QuadEdge lnext() {
        return this.dual.dual.dual.next.dual;
    }

    public QuadEdge oprev() {
        return this.dual.next.dual;
    }

    public QuadEdge dprev() {
        return this.dual.dual.dual.next.dual.dual.dual;
    }

    public QuadEdge lprev() {
        return this.next.dual.dual;
    }

    public QuadEdge dual() {
        return this.dual;
    }

    public QuadEdge next() {
        return this.next;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getCoordString() {
        if (this.getOrg() != null || this.getDest() != null) {
            return "(" + this.getOrg().getX() + ", " + this.getOrg().getY() + ") - (" + this.getDest().getX() + ", " + this.getDest().getY() + ")";
        }
        return "(null)";
    }
}

