/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.output.PushSourceOutput;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Javie2MMDOutput
extends PushSourceOutput {
    private double scale = 1.0;
    private Vec3d offset = Vec3d.ZERO;
    private ViewingAngleRounding viewingAngleRounding = ViewingAngleRounding.TO_NEAREST;
    private OutputStream stream;
    private Camera camera;
    private int writtenFrameCount;
    @Inject
    private RenderContext context;

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setOffset(Vec3d offset) {
        this.offset = offset;
    }

    public void setViewingAngleRounding(ViewingAngleRounding viewingAngleRounding) {
        this.viewingAngleRounding = viewingAngleRounding;
    }

    public void setComposition(Composition composition) {
        if (!(composition instanceof LayerComposition)) {
            throw new UnsupportedOperationException();
        }
        final LayerComposition layerComp = (LayerComposition)composition;
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke((Object)layerComp, args);
                if (method.getName().equals("renderVideoFrame")) {
                    Javie2MMDOutput.this.camera = Javie2MMDOutput.this.context.getCamera();
                }
                return result;
            }
        };
        super.setComposition((LayerComposition)Proxy.newProxyInstance(LayerComposition.class.getClassLoader(), new Class[]{LayerComposition.class}, handler));
    }

    protected void initialize() {
        LayerComposition comp = (LayerComposition)this.getComposition();
        for (Layer layer : comp.getLayers()) {
            if (layer instanceof CameraLayer || !LayerNature.isVideoNature(layer)) continue;
            LayerNature.setVideoEnabled(layer, false);
        }
        try {
            this.stream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            int i = 0;
            while (i < 62) {
                this.stream.write(0);
                ++i;
            }
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
    }

    protected void finish() {
        if (this.stream != null) {
            try {
                this.writeInt(0);
                this.writeInt(0);
                this.stream.close();
                RandomAccessFile out = new RandomAccessFile(this.getFile(), "rw");
                try {
                    String header = "Vocaloid Motion Data 0002\u0000JKLM\u30ab\u30e1\u30e9\u30fb\u7167\u660e\u0000on Data";
                    out.write(header.getBytes("Shift_JIS"));
                    this.writeInt(out, 0);
                    this.writeInt(out, 0);
                    this.writeInt(out, this.writtenFrameCount);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new JavieRuntimeException(e);
            }
        }
    }

    public boolean isVideoEnabled() {
        return true;
    }

    public void setVideoEnabled(boolean videoEnabled) {
        throw new UnsupportedOperationException("can't change videoEnabled");
    }

    public boolean isAudioEnabled() {
        return false;
    }

    public void setAudioEnabled(boolean audioEnabled) {
        throw new UnsupportedOperationException("can't change audioEnabled");
    }

    protected void writeVideo(long frameNumber, Time time, IVideoBuffer vb) {
        double[] prjMatrix = this.camera.getProjection3D();
        double[] mvMatrix = this.camera.getModelView3D();
        Size2i size = this.getComposition().getSize();
        int w = size.width;
        int h = size.height;
        int[] nArray = new int[4];
        nArray[2] = w;
        nArray[3] = h;
        int[] viewport = nArray;
        double[][] unprj = new double[4][3];
        GLU glu = this.context.getGLU();
        glu.gluUnProject((double)w * 0.5, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[0], 0);
        glu.gluUnProject((double)w * 0.5, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[1], 0);
        glu.gluUnProject((double)w * 0.5, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[2], 0);
        glu.gluUnProject((double)w * 0.5, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[3], 0);
        Vector3d v1 = new Vector3d();
        Vector3d v2 = new Vector3d();
        v1.sub((Tuple3d)new Point3d(unprj[1]), (Tuple3d)new Point3d(unprj[0]));
        v2.sub((Tuple3d)new Point3d(unprj[3]), (Tuple3d)new Point3d(unprj[2]));
        double viewingAngle = Math.acos(v1.dot(v2) / (v1.length() * v2.length()));
        Matrix4d mi = new Matrix4d(mvMatrix);
        mi.transpose();
        mi.invert();
        Point3d pc = new Point3d(0.0, 0.0, 0.0);
        mi.transform(pc);
        double length = (double)(-h) / (2.0 * Math.tan(viewingAngle / 2.0));
        Point3d po = new Point3d(0.0, 0.0, length);
        mi.transform(po);
        length = -po.distance(pc);
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)po, (Tuple3d)pc);
        double ry = Math.atan2(v.x, v.z);
        double rx = -Math.atan2(v.y, Math.hypot(v.x, v.z));
        Matrix4d mry = new Matrix4d();
        Matrix4d mrx = new Matrix4d();
        mry.rotY(ry);
        mrx.rotX(rx);
        Matrix4d mryx = new Matrix4d();
        mryx.mul(mry, mrx);
        Vector3d n1 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d n2 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d n3 = new Vector3d();
        Vector3d n4 = new Vector3d(0.0, 0.0, 1.0);
        mryx.transform(n1);
        mi.transform(n2);
        n3.cross(n1, n2);
        mryx.transform(n4);
        double dot12 = n1.dot(n2);
        double dot34 = n3.dot(n4);
        double len1 = n1.length();
        double len2 = n2.length();
        double rz = Math.acos(Math.min(Math.max(dot12 / (len1 * len2), -1.0), 1.0)) * Math.signum(dot34);
        try {
            this.writeInt((int)frameNumber);
            this.writeFloat((float)(length * this.scale));
            this.writeFloat((float)((po.x - this.offset.x) * this.scale));
            this.writeFloat((float)(-(po.y - this.offset.y) * this.scale));
            this.writeFloat((float)((po.z - this.offset.z) * this.scale));
            this.writeFloat((float)rx);
            this.writeFloat((float)(-ry));
            this.writeFloat((float)rz);
            int i = 0;
            while (i < 12) {
                this.stream.write(20);
                this.stream.write(107);
                ++i;
            }
            viewingAngle = Math.toDegrees(viewingAngle);
            switch (this.viewingAngleRounding) {
                case DOWN: {
                    viewingAngle = Math.floor(viewingAngle);
                    break;
                }
                case UP: {
                    viewingAngle = Math.ceil(viewingAngle);
                    break;
                }
                default: {
                    viewingAngle = Math.round(viewingAngle);
                }
            }
            this.writeInt((int)viewingAngle);
            this.stream.write(0);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        ++this.writtenFrameCount;
    }

    protected void writeAudio(long frameNumber, Time time, IAudioBuffer ab) {
        throw new UnsupportedOperationException();
    }

    private void writeInt(DataOutput out, int value) throws IOException {
        int i = 0;
        while (i < 4) {
            out.write(value >> i * 8 & 0xFF);
            ++i;
        }
    }

    private void writeInt(int value) throws IOException {
        int i = 0;
        while (i < 4) {
            this.stream.write(value >> i * 8 & 0xFF);
            ++i;
        }
    }

    private void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewingAngleRounding {
        TO_NEAREST,
        DOWN,
        UP;

    }
}

