/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ICamera;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.services.AbstractEffectContextProxy;
import ch.kuramo.javie.core.internal.services.VideoEffectPipelineImpl;
import ch.kuramo.javie.core.services.QCIntegrationSupport;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoEffectContextProxy
extends AbstractEffectContextProxy<IVideoEffectContext>
implements IVideoEffectContext,
QCIntegrationSupport {
    private static final ThreadLocal<LinkedList<VideoEffectPipelineImpl.VideoEffectContextImpl>> _threadLocal = new ThreadLocal();
    private static final QCIntegrationSupport NULL_QCIS = new QCIntegrationSupport(){
        private final Object[] EMPTY = new Object[0];

        public void clear() {
        }

        public void setSyncWithCamera() {
        }

        public boolean isSyncWithCamera() {
            return false;
        }

        public void setValueForInputKey(String key, Boolean value) {
        }

        public void setValueForInputKey(String key, Integer value) {
        }

        public void setValueForInputKey(String key, Double value) {
        }

        public void setValueForInputKey(String key, String value) {
        }

        public void setValueForInputKey(String key, Color value) {
        }

        public Object[] getInputKeyValues() {
            return this.EMPTY;
        }
    };

    static void push(VideoEffectPipelineImpl.VideoEffectContextImpl impl) {
        VideoEffectContextProxy.getStack(true).addLast(impl);
    }

    static void pop() {
        LinkedList<VideoEffectPipelineImpl.VideoEffectContextImpl> stack = VideoEffectContextProxy.getStack(false);
        stack.removeLast();
        if (stack.isEmpty()) {
            _threadLocal.remove();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LinkedList<VideoEffectPipelineImpl.VideoEffectContextImpl> getStack(boolean create) {
        void var1_3;
        LinkedList<VideoEffectPipelineImpl.VideoEffectContextImpl> linkedList = _threadLocal.get();
        if (linkedList == null) {
            if (!create) throw new IllegalStateException("no stack is found");
            LinkedList linkedList2 = Util.newLinkedList();
            _threadLocal.set(linkedList2);
            return var1_3;
        } else {
            if (!linkedList.isEmpty()) return var1_3;
            throw new IllegalStateException("stack is empty");
        }
    }

    @Override
    protected VideoEffectPipelineImpl.VideoEffectContextImpl getImpl() {
        return VideoEffectContextProxy.getStack(false).getLast();
    }

    public VideoBounds getPreviousBounds() {
        return this.getImpl().getPreviousBounds();
    }

    public IVideoBuffer doPreviousEffect() {
        return this.getImpl().doPreviousEffect();
    }

    public ICamera getCamera() {
        return this.getImpl().getCamera();
    }

    private QCIntegrationSupport getQCISImpl() {
        if (_threadLocal.get() != null) {
            return this.getImpl().getQCISImpl();
        }
        return NULL_QCIS;
    }

    @Override
    public void clear() {
        this.getQCISImpl().clear();
    }

    @Override
    public void setSyncWithCamera() {
        this.getQCISImpl().setSyncWithCamera();
    }

    @Override
    public boolean isSyncWithCamera() {
        return this.getQCISImpl().isSyncWithCamera();
    }

    @Override
    public void setValueForInputKey(String key, Boolean value) {
        this.getQCISImpl().setValueForInputKey(key, value);
    }

    @Override
    public void setValueForInputKey(String key, Integer value) {
        this.getQCISImpl().setValueForInputKey(key, value);
    }

    @Override
    public void setValueForInputKey(String key, Double value) {
        this.getQCISImpl().setValueForInputKey(key, value);
    }

    @Override
    public void setValueForInputKey(String key, String value) {
        this.getQCISImpl().setValueForInputKey(key, value);
    }

    @Override
    public void setValueForInputKey(String key, Color value) {
        this.getQCISImpl().setValueForInputKey(key, value);
    }

    @Override
    public Object[] getInputKeyValues() {
        return this.getQCISImpl().getInputKeyValues();
    }
}

