/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.services.IVBOCache;
import ch.kuramo.javie.core.internal.services.VBOCacheImpl;
import com.google.inject.Inject;
import com.google.inject.Injector;

public class VBOCacheProxy
implements IVBOCache {
    private static final ThreadLocal<VBOCacheImpl> threadLocal = new ThreadLocal();

    private VBOCacheImpl getImpl() {
        VBOCacheImpl impl = threadLocal.get();
        if (impl == null) {
            throw new IllegalStateException("No VBOCacheImpl exist on this thread.");
        }
        return impl;
    }

    public Object put(Object referent, IVBOCache.VBOCacheRecord record) {
        return this.getImpl().put(referent, record);
    }

    public IVBOCache.VBOCacheRecord get(Object referent) {
        return this.getImpl().get(referent);
    }

    public IVBOCache.VBOCacheRecord remove(Object referent) {
        return this.getImpl().remove(referent);
    }

    public Object delete(Object referent) {
        return this.getImpl().delete(referent);
    }

    static class Lifecycle {
        private final Injector injector;

        @Inject
        Lifecycle(Injector injector) {
            this.injector = injector;
        }

        void createImpl() {
            if (threadLocal.get() != null) {
                throw new IllegalStateException("VBOCacheImpl already exists on this thread.");
            }
            VBOCacheImpl impl = (VBOCacheImpl)this.injector.getInstance(VBOCacheImpl.class);
            threadLocal.set(impl);
        }

        void disposeImpl() {
            VBOCacheImpl impl = (VBOCacheImpl)threadLocal.get();
            if (impl != null) {
                impl.dispose();
                threadLocal.set(null);
            }
        }

        void pollAndDelete() {
            VBOCacheImpl impl = (VBOCacheImpl)threadLocal.get();
            if (impl != null) {
                impl.pollAndDelete();
            }
        }
    }
}

