/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEffectContext
implements IEffectContext {
    private final MediaLayer _layer;
    private final RenderContext _context;
    private final IVideoRenderSupport _vrSupport;
    private final AudioRenderSupport _arSupport;

    public AbstractEffectContext(MediaLayer layer, RenderContext context, IVideoRenderSupport vrSupport, AudioRenderSupport arSupport) {
        this._layer = layer;
        this._context = context;
        this._vrSupport = vrSupport;
        this._arSupport = arSupport;
    }

    public Time getTime() {
        return this._context.getTime();
    }

    public void setTime(Time time) {
        this._context.setTime(time);
    }

    public Quality getQuality() {
        return LayerNature.getQuality(this._layer);
    }

    public Resolution getVideoResolution() {
        return this._context.getVideoResolution();
    }

    public ColorMode getColorMode() {
        return this._context.getColorMode();
    }

    public AudioMode getAudioMode() {
        return this._context.getAudioMode();
    }

    public int getAudioFrameCount() {
        return this._context.getAudioFrameCount();
    }

    public void setAudioFrameCount(int count) {
        this._context.setAudioFrameCount(count);
    }

    public GL getGL() {
        return this._context.getGL();
    }

    public GLU getGLU() {
        return this._context.getGLU();
    }

    public IVideoBuffer createVideoBuffer(VideoBounds bounds) {
        return this._vrSupport.createVideoBuffer(bounds);
    }

    public IAudioBuffer createAudioBuffer() {
        return this._arSupport.createAudioBuffer();
    }

    public <V> V value(IAnimatableValue<V> avalue) {
        AnimatableValue av = (AnimatableValue)avalue;
        return av.value(this._context);
    }

    public IVideoBuffer getLayerVideoFrame(IAnimatableLayerReference layerRef) {
        Composition comp = this._context.getComposition();
        if (!(comp instanceof LayerComposition)) {
            throw new IllegalStateException("Composition in current context is not LayerComposition");
        }
        final LayerComposition layerComp = (LayerComposition)comp;
        final Layer layer = layerComp.getLayer((String)this.value((IAnimatableValue)layerRef));
        if (layer == null) {
            return null;
        }
        return this._context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

            @Override
            public IVideoBuffer execute() {
                return layerComp.getLayerVideoFrame(layer, true);
            }
        });
    }

    public IAudioBuffer getLayerAudioChunk(IAnimatableLayerReference layerRef) {
        Composition comp = this._context.getComposition();
        if (!(comp instanceof LayerComposition)) {
            throw new IllegalStateException("Composition in current context is not LayerComposition");
        }
        final LayerComposition layerComp = (LayerComposition)comp;
        final Layer layer = layerComp.getLayer((String)this.value((IAnimatableValue)layerRef));
        if (layer == null) {
            return null;
        }
        return this._context.saveAndExecute(new WrappedOperation<IAudioBuffer>(){

            @Override
            public IAudioBuffer execute() {
                return layerComp.getLayerAudioChunk(layer, true);
            }
        });
    }
}

