/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import java.util.Arrays;
import java.util.TreeSet;

class CharacterGroup {
    static final int MIN_CODE_POINT = 0;
    static final int MAX_CODE_POINT = 65535;
    static final int MIN_MAPPED_SYMBOL = 0x110000;
    static final int MAX_MAPPED_SYMBOL = 0x11001F;
    static final int MIN_MAPPED_HIRAGANA = 0x110020;
    static final int MAX_MAPPED_HIRAGANA = 1114236;
    private static final TreeSet<Integer> BLOCKS = new TreeSet<Integer>(Arrays.asList(0, 33, 48, 58, 65, 91, 97, 123, 127, 128, 256, 384, 592, 688, 768, 880, 1024, 1280, 1328, 1424, 1536, 1792, 1872, 1920, 1984, 2304, 2432, 2560, 2688, 2816, 2944, 3072, 3200, 3328, 3456, 3584, 3712, 3840, 4096, 4256, 4352, 4608, 4992, 5024, 5120, 5760, 5792, 5888, 5920, 5952, 5984, 6016, 6144, 6320, 6400, 6480, 6528, 6624, 6656, 7424, 7552, 7680, 7936, 8192, 8304, 8352, 8400, 8448, 8528, 8592, 8704, 8960, 9216, 9280, 9312, 9472, 9600, 9632, 9728, 9984, 10176, 10224, 10240, 10496, 10624, 10752, 11008, 11264, 11904, 12032, 12256, 12272, 12288, 12352, 12353, 12439, 12441, 12448, 12544, 12592, 12688, 12704, 12736, 12784, 12800, 13056, 13312, 19904, 19968, 40960, 42128, 42192, 44032, 55216, 55296, 56192, 56320, 57344, 63744, 64256, 64336, 65024, 65040, 65056, 65072, 65104, 65136, 65280, 65520, 65536));

    CharacterGroup() {
    }

    static int map(int codePoint) {
        switch (BLOCKS.headSet(codePoint + 1).last()) {
            case 33: {
                return 0x110000 + (codePoint - 33);
            }
            case 58: {
                return 0x11000F + (codePoint - 58);
            }
            case 91: {
                return 0x110016 + (codePoint - 91);
            }
            case 123: {
                return 0x11001C + (codePoint - 123);
            }
            case 12353: {
                return 0x110020 + (codePoint - 12353);
            }
            case 12441: {
                return 1114230 + (codePoint - 12441);
            }
        }
        return codePoint;
    }

    static int unmap(int codePoint) {
        if (codePoint >= 0x110000 && codePoint <= 0x11001F) {
            codePoint -= 0x110000;
            if ((codePoint += 33) >= 48) {
                codePoint += 10;
            }
            if (codePoint >= 65) {
                codePoint += 26;
            }
            if (codePoint >= 97) {
                codePoint += 26;
            }
        } else if (codePoint >= 0x110020 && codePoint <= 1114236) {
            codePoint -= 0x110020;
            if ((codePoint += 12353) >= 12439) {
                codePoint += 2;
            }
        }
        return codePoint;
    }

    static int[] rangeOf(int codePoint) {
        int next;
        int start;
        if (codePoint >= 0 && codePoint <= 65535) {
            start = BLOCKS.headSet(codePoint + 1).last();
            next = BLOCKS.tailSet(codePoint + 1).first();
        } else if (codePoint >= 0x110000 && codePoint <= 0x11001F) {
            start = 0x110000;
            next = 0x110020;
        } else if (codePoint >= 0x110020 && codePoint <= 1114236) {
            start = 0x110020;
            next = 1114237;
        } else {
            throw new IllegalArgumentException();
        }
        return new int[]{start, next};
    }

    static int[] fullRange() {
        int[] nArray = new int[2];
        nArray[1] = 65536;
        return nArray;
    }
}

