/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.core.AbstractAnimatableEnum;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Expressionee;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public abstract class AbstractTASelector
implements TASelector {
    private boolean enabled = true;
    private String name;
    private TASelector.Base base = TASelector.Base.CHARACTERS;

    public AbstractTASelector(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TASelector.Base getBase() {
        return this.base;
    }

    public void setBase(TASelector.Base base) {
        this.base = base;
    }

    public abstract class AbstractEvaluator
    implements TASelector.Evaluator {
        private final int[] totals;
        private final int[][] rndOrderTable;

        public AbstractEvaluator(int[] totals) {
            this(totals, null);
        }

        public AbstractEvaluator(int[] totals, Random rndOrder) {
            this.totals = totals;
            this.rndOrderTable = rndOrder != null ? this.createRndOrderTable(totals, rndOrder) : null;
        }

        private int[][] createRndOrderTable(int[] totals, Random rndOrder) {
            int[][] table = new int[4][];
            List<Integer> list = Util.newList();
            int i = 0;
            while (i < 4) {
                list.clear();
                int j = 0;
                while (j < totals[i]) {
                    list.add(j);
                    ++j;
                }
                Collections.shuffle(list, rndOrder);
                table[i] = new int[totals[i]];
                j = 0;
                while (j < totals[i]) {
                    table[i][j] = (Integer)list.get(j);
                    ++j;
                }
                ++i;
            }
            return table;
        }

        public double[] evaluate(double[] combine, int[] indices) {
            return this.evaluate(combine, new int[][]{indices});
        }

        public double[] evaluate(double[] combine, int[][] indices) {
            int ordinal = AbstractTASelector.this.getBase().ordinal();
            int index0 = -1;
            int index1 = -1;
            int i = 0;
            while (i < indices.length) {
                int index = indices[i][ordinal];
                if (index >= 0) {
                    if (this.rndOrderTable != null) {
                        index = this.rndOrderTable[ordinal][index];
                        if (index0 < 0 || index0 > index) {
                            index0 = index;
                        }
                        index1 = Math.max(index1, index + 1);
                    } else {
                        if (index0 < 0) {
                            index0 = index;
                        }
                        index1 = index + 1;
                    }
                }
                ++i;
            }
            if (index0 < 0) {
                return combine;
            }
            return this.evaluate(combine, index0, index1, this.totals[ordinal]);
        }

        protected abstract double[] evaluate(double[] var1, int var2, int var3, int var4);

        protected double[] applyMode(TASelector.Mode mode, double[] combine, double[] tvec) {
            block11: {
                block10: {
                    if (combine == null) break block10;
                    int i = 0;
                    while (i < 3) {
                        switch (mode) {
                            case ADD: {
                                int n = i;
                                tvec[n] = tvec[n] + combine[i];
                                break;
                            }
                            case SUBTRACT: {
                                tvec[i] = combine[i] - tvec[i];
                                break;
                            }
                            case INTERSECT: {
                                int n = i;
                                tvec[n] = tvec[n] * combine[i];
                                break;
                            }
                            case MIN: {
                                tvec[i] = Math.min(tvec[i], combine[i]);
                                break;
                            }
                            case MAX: {
                                tvec[i] = Math.max(tvec[i], combine[i]);
                                break;
                            }
                            case DIFFERENCE: {
                                tvec[i] = Math.abs(tvec[i] - combine[i]);
                                break;
                            }
                            default: {
                                throw new RuntimeException("unknown Mode: " + mode.name());
                            }
                        }
                        tvec[i] = Math.min(Math.max(tvec[i], -1.0), 1.0);
                        ++i;
                    }
                    break block11;
                }
                if (mode != TASelector.Mode.SUBTRACT) break block11;
                int i = 0;
                while (i < 3) {
                    tvec[i] = 1.0 - tvec[i];
                    ++i;
                }
            }
            return tvec;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableMode
    extends AbstractAnimatableEnum<TASelector.Mode> {
        public AnimatableMode(TASelector.Mode staticValue, Collection<Keyframe<TASelector.Mode>> keyframes, String expression) {
            super(TASelector.Mode.class, staticValue, keyframes, expression);
        }

        public AnimatableMode(TASelector.Mode defaultValue) {
            super(TASelector.Mode.class, defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TASelectorExpressionElement {
        protected final CoreContext context;

        public TASelectorExpressionElement(CoreContext context) {
            this.context = context;
        }

        protected <T> T elem(Expressionee exprnee) {
            return this.context.getExpressionElement(exprnee);
        }

        public boolean isEnabled() {
            return AbstractTASelector.this.enabled;
        }

        public String getName() {
            return AbstractTASelector.this.name;
        }

        public String getBase() {
            return AbstractTASelector.this.base.name();
        }
    }
}

