/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.transition;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

@Effect(id="ch.kuramo.javie.LinearWipe", category="ch.kuramo.javie.api.effectCategory.transition")
public class LinearWipe {
    @Property(min="0", max="100")
    private IAnimatableDouble transitionCompletion;
    @Property(value="90")
    private IAnimatableDouble wipeAngle;
    @Property(min="0", max="32000")
    private IAnimatableDouble feather;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final ITexture1DSupport tex1DSupport;
    private final IArrayPools arrayPools;

    @Inject
    public LinearWipe(IVideoEffectContext context, IVideoRenderSupport support, ITexture1DSupport tex1DSupport, IArrayPools arrayPools) {
        this.context = context;
        this.support = support;
        this.tex1DSupport = tex1DSupport;
        this.arrayPools = arrayPools;
    }

    public IVideoBuffer doVideoEffect() {
        double completion = (Double)this.context.value((IAnimatableValue)this.transitionCompletion) / 100.0;
        if (completion == 1.0) {
            IVideoBuffer buffer = this.context.createVideoBuffer(this.context.getPreviousBounds());
            buffer.clear();
            return buffer;
        }
        IVideoBuffer input = this.context.doPreviousEffect();
        if (completion == 0.0) {
            return input;
        }
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        double wipeAngle = (Double)this.context.value((IAnimatableValue)this.wipeAngle) % 360.0;
        if (wipeAngle < 0.0) {
            wipeAngle += 360.0;
        }
        double feather = (Double)this.context.value((IAnimatableValue)this.feather);
        feather = this.context.getVideoResolution().scale(feather);
        double x = bounds.x;
        double y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        double theta = Math.toRadians(wipeAngle);
        double wipeLen = (double)h * Math.abs(Math.cos(theta)) + (double)w * Math.abs(Math.sin(theta));
        double wipeWidth = (double)w * Math.abs(Math.cos(theta)) + (double)h * Math.abs(Math.sin(theta));
        int wipeTex = 0;
        try {
            final float[] texCoords = new float[2];
            final int tex = wipeTex = this.createWipeTexture(wipeLen, completion, feather, texCoords);
            final VideoBounds b = bounds;
            final float tx = (float)(x + (double)w / 2.0);
            final float ty = (float)(y + (double)h / 2.0);
            final float rz = (float)wipeAngle;
            final float sx = (float)(wipeWidth / (double)w);
            final float sy = (float)(wipeLen / (double)h);
            final float vx0 = (float)x;
            final float vy0 = (float)y;
            final float vx1 = (float)(x + (double)w);
            final float vy1 = (float)(y + (double)h);
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = LinearWipe.this.context.getGL().getGL2();
                    LinearWipe.this.support.ortho2D(b);
                    gl.glMatrixMode(5888);
                    gl.glTranslatef(tx, ty, 0.0f);
                    gl.glRotatef(rz, 0.0f, 0.0f, 1.0f);
                    gl.glScalef(sx, sy, 1.0f);
                    gl.glTranslatef(-tx, -ty, 0.0f);
                    gl.glEnable(3042);
                    gl.glBlendFuncSeparate(0, 770, 0, 770);
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(3552, tex);
                    gl.glEnable(3552);
                    gl.glBegin(7);
                    gl.glTexCoord1f(texCoords[0]);
                    gl.glVertex2f(vx0, vy0);
                    gl.glTexCoord1f(texCoords[0]);
                    gl.glVertex2f(vx1, vy0);
                    gl.glTexCoord1f(texCoords[1]);
                    gl.glVertex2f(vx1, vy1);
                    gl.glTexCoord1f(texCoords[1]);
                    gl.glVertex2f(vx0, vy1);
                    gl.glEnd();
                }
            };
            int pushAttribs = 286720;
            this.support.useFramebuffer(operation, pushAttribs, input, new IVideoBuffer[0]);
            IVideoBuffer result = input;
            input = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (wipeTex != 0) {
                this.deleteTexture(wipeTex);
            }
        }
    }

    private int createWipeTexture(double wipeLen, double completion, double feather, float[] texCoords) {
        int dataLen = (int)Math.ceil(feather) * 2 + 2;
        IArray data = this.arrayPools.getFloatArray(dataLen);
        try {
            float[] array = (float[])data.getArray();
            if (feather > 0.0) {
                double sigma = feather / 2.5;
                double twoSigmaSq = 2.0 * sigma * sigma;
                double k1 = 1.2732395447351628;
                double k2 = 0.1400122886866665;
                int i = 1;
                while (i < dataLen - 1) {
                    double d = (double)(i - dataLen / 2) + 0.5;
                    double t2 = d * d / twoSigmaSq;
                    double erf = Math.signum(d) * Math.sqrt(1.0 - Math.exp(-t2 * (k1 + k2 * t2) / (1.0 + k2 * t2)));
                    array[i] = (float)(0.5 * (1.0 + erf));
                    ++i;
                }
            }
            array[0] = 0.0f;
            array[dataLen - 1] = 1.0f;
            double a = 0.5 * (wipeLen - (double)dataLen) / (double)dataLen;
            double b = ((double)dataLen * 0.5 - feather) / (double)dataLen;
            texCoords[0] = (float)((2.0 + 2.0 * a - b) * (1.0 - completion) + b * completion);
            texCoords[1] = (float)((1.0 - b) * (1.0 - completion) - (1.0 + 2.0 * a - b) * completion);
            Quality quality = this.context.getQuality();
            Resolution resolution = this.context.getVideoResolution();
            ColorMode colorMode = this.context.getColorMode();
            int internalFormat = quality == Quality.DRAFT || resolution.scale < 1.0 ? 32828 : (colorMode == ColorMode.RGBA32_FLOAT ? 34838 : (colorMode == ColorMode.RGBA16_FLOAT ? 34844 : (quality == Quality.BEST ? 34844 : 32828)));
            int n = this.tex1DSupport.texture1DFromArray(data, 6406, internalFormat);
            return n;
        }
        finally {
            data.release();
        }
    }

    private void deleteTexture(int texture) {
        GL2 gl = this.context.getGL().getGL2();
        gl.glDeleteTextures(1, new int[]{texture}, 0);
    }
}

