/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.time;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.PosterizeTime", category="ch.kuramo.javie.api.effectCategory.time")
public class PosterizeTime {
    @Property(value="24", min="0.01", max="120")
    private IAnimatableDouble frameRate;
    private final IVideoEffectContext context;

    @Inject
    public PosterizeTime(IVideoEffectContext context) {
        this.context = context;
    }

    public IVideoBuffer doVideoEffect() {
        Time time = this.context.getTime();
        double frameRate = (Double)this.context.value((IAnimatableValue)this.frameRate);
        long frameNumber = (long)(time.toSecond() * frameRate);
        long timeValue = Math.round((double)frameNumber / frameRate * (double)time.timeScale);
        this.context.setTime(new Time(timeValue, time.timeScale));
        return this.context.doPreviousEffect();
    }
}

