/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.MotionTile", category="ch.kuramo.javie.api.effectCategory.stylize")
public class MotionTile {
    @Property
    private IAnimatableVec2d tileCenter;
    @Property(value="100", min="0", max="100")
    private IAnimatableVec2d tileSize;
    @Property(value="100", min="0")
    private IAnimatableVec2d outputSize;
    @Property
    private IAnimatableBoolean mirrorEdges;
    @Property
    private IAnimatableDouble phase;
    @Property
    private IAnimatableBoolean horizontalPhaseShift;
    @Property(value="true")
    private IAnimatableBoolean interpolation;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram hPhaseProgram;
    private final IShaderProgram vPhaseProgram;
    @ShaderSource
    public static final String[] HPHASE = MotionTile.createProgramSource(true);
    @ShaderSource
    public static final String[] VPHASE = MotionTile.createProgramSource(false);

    @Inject
    public MotionTile(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.hPhaseProgram = shaders.getProgram(MotionTile.class, "HPHASE");
        this.vPhaseProgram = shaders.getProgram(MotionTile.class, "VPHASE");
    }

    private VideoBounds calcOutputBounds(VideoBounds sourceBounds, Vec2d outputSize, double[] ltrb) {
        double w = (double)sourceBounds.width * outputSize.x / 100.0;
        double h = (double)sourceBounds.height * outputSize.y / 100.0;
        double left = sourceBounds.x - (w - (double)sourceBounds.width) / 2.0;
        double top = sourceBounds.y - (h - (double)sourceBounds.height) / 2.0;
        double right = left + w;
        double bottom = top + h;
        if (ltrb != null) {
            ltrb[0] = left;
            ltrb[1] = top;
            ltrb[2] = right;
            ltrb[3] = bottom;
        }
        double x = sourceBounds.x + (double)((int)Math.floor(left - sourceBounds.x));
        double y = sourceBounds.y + (double)((int)Math.floor(top - sourceBounds.y));
        return new VideoBounds(x, y, (int)Math.ceil(right - x), (int)Math.ceil(bottom - y));
    }

    public VideoBounds getVideoBounds() {
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        Vec2d outputSize = (Vec2d)this.context.value((IAnimatableValue)this.outputSize);
        return this.calcOutputBounds(bounds, outputSize, null);
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        IVideoBuffer buf1 = null;
        IVideoBuffer buf2 = null;
        try {
            Resolution resolution = this.context.getVideoResolution();
            Quality quality = this.context.getQuality();
            Vec2d tileCenter = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.tileCenter));
            Vec2d tileSize = (Vec2d)this.context.value((IAnimatableValue)this.tileSize);
            Vec2d outputSize = (Vec2d)this.context.value((IAnimatableValue)this.outputSize);
            boolean mirror = (Boolean)this.context.value((IAnimatableValue)this.mirrorEdges);
            double phase = (Double)this.context.value((IAnimatableValue)this.phase) / 360.0;
            boolean hPhase = (Boolean)this.context.value((IAnimatableValue)this.horizontalPhaseShift);
            boolean interpolation = (Boolean)this.context.value((IAnimatableValue)this.interpolation);
            double tileWidth = Math.max(1.0, (double)bounds.width * tileSize.x / 100.0);
            double tileHeight = Math.max(1.0, (double)bounds.height * tileSize.y / 100.0);
            final VideoBounds tileBounds = new VideoBounds((int)tileWidth, (int)tileHeight);
            buf1 = this.support.createVideoBuffer(tileBounds);
            source.setTextureFilter(quality == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : (interpolation ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR));
            source.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = MotionTile.this.context.getGL().getGL2();
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    MotionTile.this.support.ortho2D(tileBounds);
                    MotionTile.this.support.quad2D(tileBounds, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
                }
            };
            int pushAttribs = 1;
            this.support.useFramebuffer(operation, pushAttribs, buf1, new IVideoBuffer[]{source});
            source.dispose();
            source = null;
            double[] ltrb = new double[4];
            VideoBounds outputBounds = this.calcOutputBounds(bounds, outputSize, ltrb);
            buf2 = this.support.createVideoBuffer(outputBounds);
            ltrb[0] = ltrb[0] - outputBounds.x;
            ltrb[1] = ltrb[1] - outputBounds.y;
            ltrb[2] = ltrb[2] - outputBounds.x;
            ltrb[3] = ltrb[3] - outputBounds.y;
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("tileCenter", 2, this.toFloatBuffer(tileCenter.x - outputBounds.x, tileCenter.y - outputBounds.y)));
            uniforms.add(new GLUniformData("tileSize", 2, this.toFloatBuffer(tileWidth, tileHeight)));
            uniforms.add(new GLUniformData("phase", (float)phase));
            uniforms.add(new GLUniformData("ltrb", 4, this.toFloatBuffer(ltrb)));
            buf1.setTextureWrapMode(mirror ? IVideoBuffer.TextureWrapMode.MIRRORED_REPEAT : IVideoBuffer.TextureWrapMode.REPEAT);
            buf1.setTextureFilter(quality == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : IVideoBuffer.TextureFilter.LINEAR);
            IShaderProgram program = hPhase ? this.hPhaseProgram : this.vPhaseProgram;
            this.support.useShaderProgram(program, uniforms, buf2, new IVideoBuffer[]{buf1});
            IVideoBuffer result = buf2;
            buf2 = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (source != null) {
                source.dispose();
            }
            if (buf1 != null) {
                buf1.dispose();
            }
            if (buf2 != null) {
                buf2.dispose();
            }
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private static String[] createProgramSource(boolean hPhase) {
        return new String[]{hPhase ? "#define HPHASE" : "", "", "uniform sampler2D texture;", "uniform vec2 tileCenter;", "uniform vec2 tileSize;", "uniform float phase;", "uniform vec4 ltrb;", "", "void main(void)", "{", "\tvec2 xy = gl_FragCoord.xy;", "\tvec2 tc = (xy-tileCenter)/tileSize + vec2(0.5);", "#ifdef HPHASE", "\ttc.x -= step(mod(tc.y, 2.0), 1.0) * phase;", "#else", "\ttc.y -= step(mod(tc.x, 2.0), 1.0) * phase;", "#endif", "\tvec4 a = clamp(vec4(xy-ltrb.xy, ltrb.zw-xy)+vec4(0.5), 0.0, 1.0);", "\ta.xy *= a.zw;", "\tgl_FragColor = texture2D(texture, tc)*a.x*a.y;", "}"};
    }
}

