/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.distort;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Twirl", category="ch.kuramo.javie.api.effectCategory.distort")
public class Twirl {
    @Property
    private IAnimatableDouble angle;
    @Property(value="30", min="0")
    private IAnimatableDouble twirlRadius;
    @Property
    private IAnimatableVec2d twirlCenter;
    @Property(value="0", min="0")
    private IAnimatableDouble ease;
    @Property(value="true")
    private IAnimatableBoolean interpolation;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram program;
    @ShaderSource
    public static final String[] TWIRL = new String[]{"uniform sampler2D texture;", "uniform vec2 size;", "uniform vec2 center;", "uniform float radius;", "uniform float angle;", "uniform float ease;", "", "void main(void)", "{", "\tvec2 xy = gl_FragCoord.xy;", "\tfloat d = distance(xy, center);", "\tfloat a = angle * pow(max(0.0, radius-d)/radius, ease);", "\tfloat cos = cos(a);", "\tfloat sin = sin(a);", "\tvec2 tc = (mat2(cos,-sin,sin,cos)*(xy-center)+center) / size;", "", "\tgl_FragColor = texture2D(texture, tc);", "}"};

    @Inject
    public Twirl(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.program = shaders.getProgram(Twirl.class, "TWIRL");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        double angle = Math.toRadians((Double)this.context.value((IAnimatableValue)this.angle));
        double radius = (Double)this.context.value((IAnimatableValue)this.twirlRadius) / 100.0 * (double)Math.max(bounds.width, bounds.height);
        if (angle == 0.0 || radius == 0.0) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        Vec2d center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.twirlCenter));
        double ease = (Double)this.context.value((IAnimatableValue)this.ease) + 1.0;
        boolean interpolation = (Boolean)this.context.value((IAnimatableValue)this.interpolation);
        IVideoBuffer.TextureFilter filter = this.context.getQuality() == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : (interpolation ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR);
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("size", 2, this.toFloatBuffer(bounds.width, bounds.height)));
            uniforms.add(new GLUniformData("center", 2, this.toFloatBuffer(center.x - bounds.x, center.y - bounds.y)));
            uniforms.add(new GLUniformData("radius", (float)radius));
            uniforms.add(new GLUniformData("angle", (float)angle));
            uniforms.add(new GLUniformData("ease", (float)ease));
            source.setTextureFilter(filter);
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.program, uniforms, null, new IVideoBuffer[]{source});
            return iVideoBuffer;
        }
        finally {
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }
}

