/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.distort;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Ripple", category="ch.kuramo.javie.api.effectCategory.distort")
public class Ripple {
    @Property(value="0", min="0")
    private IAnimatableDouble radius;
    @Property
    private IAnimatableVec2d centerOfRipple;
    @Property(value="ASYMMETRIC")
    private IAnimatableEnum<TypeOfConversion> typeOfConversion;
    @Property(value="1", min="-15", max="15")
    private IAnimatableDouble waveSpeed;
    @Property(value="20", min="2")
    private IAnimatableDouble waveWidth;
    @Property(value="20", min="0")
    private IAnimatableDouble waveHeight;
    @Property
    private IAnimatableDouble ripplePhase;
    @Property(value="true")
    private IAnimatableBoolean interpolation;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderRegistry shaders;

    @Inject
    public Ripple(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.shaders = shaders;
    }

    private VideoBounds calcVideoBounds(VideoBounds srcBounds, double radius, Vec2d center, TypeOfConversion type, double waveHeight) {
        return srcBounds;
    }

    public VideoBounds getVideoBounds() {
        VideoBounds srcBounds = this.context.getPreviousBounds();
        if (srcBounds.isEmpty()) {
            return srcBounds;
        }
        boolean repeatEdgePixels = true;
        if (repeatEdgePixels) {
            return srcBounds;
        }
        Resolution resolution = this.context.getVideoResolution();
        double radius = (Double)this.context.value((IAnimatableValue)this.radius) / 100.0 * (double)Math.max(srcBounds.width, srcBounds.height);
        Vec2d center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.centerOfRipple));
        TypeOfConversion type = (TypeOfConversion)((Object)this.context.value(this.typeOfConversion));
        double waveHeight = resolution.scale((Double)this.context.value((IAnimatableValue)this.waveHeight) * 0.3);
        return this.calcVideoBounds(srcBounds, radius, center, type, waveHeight);
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds srcBounds = source.getBounds();
        if (srcBounds.isEmpty()) {
            return source;
        }
        IVideoBuffer buffer = null;
        try {
            Resolution resolution = this.context.getVideoResolution();
            double radius = (Double)this.context.value((IAnimatableValue)this.radius) / 100.0 * (double)Math.max(srcBounds.width, srcBounds.height);
            Vec2d center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.centerOfRipple));
            TypeOfConversion type = (TypeOfConversion)((Object)this.context.value(this.typeOfConversion));
            double waveSpeed = (Double)this.context.value((IAnimatableValue)this.waveSpeed);
            double waveWidth = resolution.scale(((Double)this.context.value((IAnimatableValue)this.waveWidth)).doubleValue());
            double waveHeight = resolution.scale((Double)this.context.value((IAnimatableValue)this.waveHeight) * 0.3);
            double phase = (Double)this.context.value((IAnimatableValue)this.ripplePhase);
            boolean repeatEdgePixels = true;
            boolean interpolation = (Boolean)this.context.value((IAnimatableValue)this.interpolation);
            Time time = this.context.getTime();
            VideoBounds resultBounds = repeatEdgePixels ? srcBounds : this.calcVideoBounds(srcBounds, radius, center, type, waveHeight);
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("fragCoordOffset", 2, this.toFloatBuffer(resultBounds.x - center.x, resultBounds.y - center.y)));
            uniforms.add(new GLUniformData("texCoordOffset", 2, this.toFloatBuffer(srcBounds.x - center.x, srcBounds.y - center.y)));
            uniforms.add(new GLUniformData("o_div_txsz", 2, this.toFloatBuffer(1.0 / (double)srcBounds.width, 1.0 / (double)srcBounds.height)));
            uniforms.add(new GLUniformData("radius", (float)radius));
            uniforms.add(new GLUniformData("o_div_r", (float)(1.0 / radius)));
            uniforms.add(new GLUniformData("phase", (float)Math.toRadians(phase - 360.0 * (waveSpeed * time.toSecond()))));
            uniforms.add(new GLUniformData("o_div_ww", (float)(1.0 / waveWidth)));
            uniforms.add(new GLUniformData("waveHeight", (float)waveHeight));
            IVideoBuffer.TextureFilter filter = this.context.getQuality() == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : (interpolation ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR);
            source.setTextureFilter(filter);
            IVideoBuffer.TextureWrapMode wrapMode = repeatEdgePixels ? IVideoBuffer.TextureWrapMode.MIRRORED_REPEAT : IVideoBuffer.TextureWrapMode.CLAMP_TO_BORDER;
            source.setTextureWrapMode(wrapMode);
            buffer = this.context.createVideoBuffer(resultBounds);
            this.support.useShaderProgram(this.getProgram(type), uniforms, buffer, new IVideoBuffer[]{source});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            if (source != null) {
                source.dispose();
            }
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private IShaderProgram getProgram(TypeOfConversion type) {
        String programName = String.valueOf(Ripple.class.getName()) + "." + type.name();
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, null, this.createProgramSource(type));
        }
        return program;
    }

    private String[] createProgramSource(TypeOfConversion type) {
        return new String[]{"#define " + type.name(), "", "uniform sampler2D texture;", "uniform vec2 fragCoordOffset;", "uniform vec2 texCoordOffset;", "uniform vec2 o_div_txsz;", "uniform float radius;", "uniform float o_div_r;", "uniform float phase;", "uniform float o_div_ww;", "uniform float waveHeight;", "", "const float PI = 3.14159265358979323846264;", "", "void main(void)", "{", "\tvec2 v = gl_FragCoord.xy + fragCoordOffset;", "\tfloat d = length(v);", "", "\tv += max(0.0, (radius-d)*o_div_r) * waveHeight * cos(PI*d*o_div_ww + phase)", "#ifdef SYMMETRIC", "\t\t* (d > 0.0 ? v/d : vec2(0.0))", "#endif", "\t\t;", "", "\tvec2 texCoord = (v - texCoordOffset) * o_div_txsz;", "\tgl_FragColor = texture2D(texture, texCoord);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeOfConversion {
        ASYMMETRIC,
        SYMMETRIC;

    }
}

