/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.UnsharpMask", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class UnsharpMask {
    @Property(value="50", min="0", max="1000")
    private IAnimatableDouble amount;
    @Property(value="1", min="0", max="500")
    private IAnimatableDouble radius;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble threshold;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IShaderProgram programNoThreshold;
    private final IShaderProgram programWithThreshold;
    @ShaderSource
    public static final String[] UNSHARP_MASK = UnsharpMask.createProgramSource(false);
    @ShaderSource
    public static final String[] UNSHARP_MASK_T = UnsharpMask.createProgramSource(true);

    @Inject
    public UnsharpMask(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.programNoThreshold = shaders.getProgram(UnsharpMask.class, "UNSHARP_MASK");
        this.programWithThreshold = shaders.getProgram(UnsharpMask.class, "UNSHARP_MASK_T");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        double amount = (Double)this.context.value((IAnimatableValue)this.amount) / 100.0;
        if (amount == 0.0) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        double radius = resolution.scale(((Double)this.context.value((IAnimatableValue)this.radius)).doubleValue());
        if (radius == 0.0) {
            return source;
        }
        double threshold = (Double)this.context.value((IAnimatableValue)this.threshold) / 100.0;
        if (threshold == 1.0) {
            return source;
        }
        boolean fast = (Boolean)this.context.value((IAnimatableValue)this.fast);
        IVideoBuffer blur = null;
        try {
            IShaderProgram program;
            blur = this.blurSupport.gaussianBlur(source, radius, IBlurSupport.BlurDimensions.BOTH, true, fast);
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("srcTex", 0));
            uniforms.add(new GLUniformData("blrTex", 1));
            uniforms.add(new GLUniformData("amount", (float)amount));
            if (threshold == 0.0) {
                program = this.programNoThreshold;
            } else {
                program = this.programWithThreshold;
                uniforms.add(new GLUniformData("threshold", (float)(2.0 * threshold - 1.0)));
            }
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{source, blur});
            return iVideoBuffer;
        }
        finally {
            if (blur != null) {
                blur.dispose();
            }
            source.dispose();
        }
    }

    private static String[] createProgramSource(boolean withThreshold) {
        boolean t = withThreshold;
        return new String[]{t ? "#define WITH_THRESHOLD" : "", "", "uniform sampler2D srcTex;", "uniform sampler2D blrTex;", "uniform float amount;", "", "#ifdef WITH_THRESHOLD", "\tuniform float threshold;", "#endif", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tvec4 srcColor = texture2D(srcTex, tc);", "\tvec4 blrColor = texture2D(blrTex, tc);", "", "\tsrcColor.rgb = (srcColor.a > 0.0) ? srcColor.rgb/srcColor.a : vec3(0.0);", "\tblrColor.rgb = (blrColor.a > 0.0) ? blrColor.rgb/blrColor.a : vec3(0.0);", "", "\tvec3 diff = srcColor.rgb - blrColor.rgb;", "", "#ifdef WITH_THRESHOLD", "\tdiff *= clamp(abs(diff)-vec3(threshold), 0.0, 1.0);", "#endif", "", "\tgl_FragColor = vec4((srcColor.rgb+diff*amount)*srcColor.a, srcColor.a);", "}"};
    }
}

