/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IConvolutionSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.HashSet;

@Effect(id="ch.kuramo.javie.DirectionalBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class DirectionalBlur {
    @Property
    private IAnimatableDouble direction;
    @Property(value="0", min="0", max="500")
    private IAnimatableDouble blurLength;
    @Property(value="BOX")
    private IAnimatableEnum<BlurType> blurType;
    @Property
    private IAnimatableBoolean repeatEdgePixels;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IConvolutionSupport convolutionSupport;

    @Inject
    public DirectionalBlur(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IConvolutionSupport convolutionSupport) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.convolutionSupport = convolutionSupport;
    }

    public VideoBounds getVideoBounds() {
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        double blurLength = (Double)this.context.value((IAnimatableValue)this.blurLength);
        blurLength = this.context.getVideoResolution().scale(blurLength);
        if (blurLength == 0.0) {
            return bounds;
        }
        if (((Boolean)this.context.value((IAnimatableValue)this.repeatEdgePixels)).booleanValue()) {
            return bounds;
        }
        double direction = (Double)this.context.value((IAnimatableValue)this.direction);
        return this.calcResultBounds(bounds, direction, blurLength);
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        double blurLength = (Double)this.context.value((IAnimatableValue)this.blurLength);
        boolean fast = blurLength > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        blurLength = this.context.getVideoResolution().scale(blurLength);
        if (blurLength == 0.0) {
            return source;
        }
        double direction = (Double)this.context.value((IAnimatableValue)this.direction);
        BlurType blurType = (BlurType)((Object)this.context.value(this.blurType));
        boolean repeatEdgePixels = (Boolean)this.context.value((IAnimatableValue)this.repeatEdgePixels);
        try {
            if (fast) {
                IVideoBuffer iVideoBuffer = this.doFastDirectionalBlur(source, direction, blurLength, blurType, repeatEdgePixels);
                return iVideoBuffer;
            }
            IVideoBuffer iVideoBuffer = this.doDirectionalBlur(source, direction, blurLength, blurType, repeatEdgePixels);
            return iVideoBuffer;
        }
        finally {
            source.dispose();
        }
    }

    private IVideoBuffer doDirectionalBlur(IVideoBuffer source, double direction, double blurLength, BlurType blurType, boolean repeatEdgePixels) {
        float[] kernel;
        switch (blurType) {
            case BOX: {
                kernel = this.blurSupport.createBoxBlurKernel(blurLength);
                break;
            }
            case GAUSSIAN: {
                kernel = this.blurSupport.createGaussianBlurKernel(blurLength);
                break;
            }
            default: {
                throw new RuntimeException("unknown BlurType: " + (Object)((Object)blurType));
            }
        }
        VideoBounds bounds = source.getBounds();
        double rotRadians = Math.toRadians(direction);
        double vx = Math.sin(rotRadians) / (double)bounds.width;
        double vy = -Math.cos(rotRadians) / (double)bounds.height;
        float[] offset = new float[kernel.length * 2];
        int i = 1;
        int n = kernel.length / 2;
        while (i <= n) {
            offset[(n - i) * 2] = (float)(vx * (double)i);
            offset[(n - i) * 2 + 1] = (float)(vy * (double)i);
            offset[(n + i) * 2] = (float)(-vx * (double)i);
            offset[(n + i) * 2 + 1] = (float)(-vy * (double)i);
            ++i;
        }
        IVideoBuffer buffer = null;
        try {
            VideoBounds resultBounds = repeatEdgePixels ? bounds : this.calcResultBounds(bounds, direction, blurLength);
            buffer = this.context.createVideoBuffer(resultBounds);
            source.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            source.setTextureWrapMode(repeatEdgePixels ? IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE : IVideoBuffer.TextureWrapMode.CLAMP_TO_BORDER);
            this.convolutionSupport.convolve(source, buffer, kernel, offset);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVideoBuffer doFastDirectionalBlur(IVideoBuffer source, double direction, double blurLength, BlurType blurType, boolean repeatEdgePixels) {
        tmpBuffers = new HashSet<IVideoBuffer>();
        try {
            bounds = source.getBounds();
            rotCenter = new Vec2d(bounds.x + (double)bounds.width * 0.5, bounds.y + (double)bounds.height * 0.5);
            rotRadians = Math.toRadians(direction);
            rotatedBounds = this.calcRotatedBounds(bounds, rotCenter, -rotRadians);
            rotTexCoords = this.calcRotationTexCoords(bounds, rotatedBounds, rotCenter, -rotRadians);
            rotOp = new Runnable(){

                public void run() {
                    DirectionalBlur.this.support.ortho2D(rotatedBounds);
                    DirectionalBlur.this.support.quad2D(rotatedBounds, (double[][][])new double[][][]{rotTexCoords});
                }
            };
            source.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            source.setTextureWrapMode(repeatEdgePixels != false ? IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE : IVideoBuffer.TextureWrapMode.CLAMP_TO_BORDER);
            buffer = this.context.createVideoBuffer(rotatedBounds);
            tmpBuffers.add(buffer);
            this.support.useFramebuffer(rotOp, 0, buffer, new IVideoBuffer[]{source});
            switch (DirectionalBlur.$SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$DirectionalBlur$BlurType()[blurType.ordinal()]) {
                case 1: {
                    buffer = this.blurSupport.boxBlur(buffer, blurLength, IBlurSupport.BlurDimensions.VERTICAL, repeatEdgePixels, true, 1);
                    tmpBuffers.add(buffer);
                    break;
                }
                case 2: {
                    buffer = this.blurSupport.gaussianBlur(buffer, blurLength, IBlurSupport.BlurDimensions.VERTICAL, repeatEdgePixels, true);
                    tmpBuffers.add(buffer);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown BlurType: " + (Object)blurType);
                }
            }
            resultBounds = repeatEdgePixels != false ? bounds : this.calcResultBounds(bounds, direction, blurLength);
            revRotTexCoords = this.calcRotationTexCoords(buffer.getBounds(), resultBounds, rotCenter, rotRadians);
            revRotOp = new Runnable(){

                public void run() {
                    DirectionalBlur.this.support.ortho2D(resultBounds);
                    DirectionalBlur.this.support.quad2D(resultBounds, (double[][][])new double[][][]{revRotTexCoords});
                }
            };
            buffer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            result = this.context.createVideoBuffer(resultBounds);
            tmpBuffers.add(result);
            this.support.useFramebuffer(revRotOp, 0, result, new IVideoBuffer[]{buffer});
            tmpBuffers.remove(result);
            var22_18 = result;
            return var22_18;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl46:
        // 1 sources

        return var22_18;
    }

    private VideoBounds calcResultBounds(VideoBounds bounds, double direction, double blurLength) {
        double rotRadians = Math.toRadians(direction);
        double dx = Math.abs(Math.sin(rotRadians)) * blurLength;
        double dy = Math.abs(Math.cos(rotRadians)) * blurLength;
        return new VideoBounds(bounds.x - dx, bounds.y - dy, bounds.width + (int)Math.ceil(dx * 2.0), bounds.height + (int)Math.ceil(dy * 2.0));
    }

    private VideoBounds calcRotatedBounds(VideoBounds bounds, Vec2d rotCenter, double rotRadians) {
        double[][] pt = new double[][]{{bounds.x, bounds.y}, {bounds.x + (double)bounds.width, bounds.y}, {bounds.x + (double)bounds.width, bounds.y + (double)bounds.height}, {bounds.x, bounds.y + (double)bounds.height}};
        double cos = Math.cos(rotRadians);
        double sin = Math.sin(rotRadians);
        double left = Double.POSITIVE_INFINITY;
        double top = Double.POSITIVE_INFINITY;
        double right = Double.NEGATIVE_INFINITY;
        double bottom = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < 4) {
            this.rotate(pt[i], rotCenter, cos, sin);
            left = Math.min(pt[i][0], left);
            top = Math.min(pt[i][1], top);
            right = Math.max(pt[i][0], right);
            bottom = Math.max(pt[i][1], bottom);
            ++i;
        }
        return new VideoBounds(left, top, (int)Math.ceil(right - left), (int)Math.ceil(bottom - top));
    }

    private double[][] calcRotationTexCoords(VideoBounds bounds, VideoBounds rotatedBounds, Vec2d rotCenter, double rotRadians) {
        double x = rotatedBounds.x - bounds.x;
        double y = rotatedBounds.y - bounds.y;
        double w = rotatedBounds.width;
        double h = rotatedBounds.height;
        double[][] pt = new double[][]{{x, y}, {x + w, y}, {x + w, y + h}, {x, y + h}};
        rotCenter = new Vec2d(rotCenter.x - bounds.x, rotCenter.y - bounds.y);
        double cos = Math.cos(-rotRadians);
        double sin = Math.sin(-rotRadians);
        int i = 0;
        while (i < 4) {
            this.rotate(pt[i], rotCenter, cos, sin);
            double[] dArray = pt[i];
            dArray[0] = dArray[0] / (double)bounds.width;
            double[] dArray2 = pt[i];
            dArray2[1] = dArray2[1] / (double)bounds.height;
            ++i;
        }
        return pt;
    }

    private void rotate(double[] pt, Vec2d rotCenter, double cos, double sin) {
        double x = pt[0];
        double y = pt[1];
        double x0 = rotCenter.x;
        double y0 = rotCenter.y;
        pt[0] = (x - x0) * cos - (y - y0) * sin + x0;
        pt[1] = (x - x0) * sin + (y - y0) * cos + y0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlurType {
        BOX,
        GAUSSIAN;

    }
}

