/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.CompoundBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class CompoundBlur {
    @Property
    private IAnimatableLayerReference blurMap;
    @Property(value="0", min="0")
    private IAnimatableDouble maximumBlur;
    @Property(value="STRETCH")
    private IAnimatableEnum<MapPlacement> mapPlacement;
    @Property
    private IAnimatableBoolean invertBlur;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IShaderRegistry shaders;
    private final IShaderProgram blurConvolutionProgram;
    @ShaderSource
    public static final String[] BLUR_CONVOLUTION = new String[]{"uniform sampler2D texture;", "uniform int ksize;", "uniform float kernel[17];", "uniform vec2 offset[17];", "uniform float lod;", "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tfor (int i = 0; i < ksize; ++i) {", "\t\tsum += kernel[i] * texture2DLod(texture, texCoord + offset[i], lod);", "\t}", "\tgl_FragColor = sum;", "}"};

    @Inject
    public CompoundBlur(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.shaders = shaders;
        this.blurConvolutionProgram = shaders.getProgram(CompoundBlur.class, "BLUR_CONVOLUTION");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        double maximumBlur = resolution.scale(((Double)this.context.value((IAnimatableValue)this.maximumBlur)).doubleValue());
        if (maximumBlur == 0.0) {
            return source;
        }
        IVideoBuffer blurMap = null;
        IVideoBuffer mipmap = null;
        try {
            blurMap = this.context.getLayerVideoFrame(this.blurMap);
            if (blurMap == null) {
                IVideoBuffer result = source;
                source = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            MapPlacement mapPlacement = (MapPlacement)((Object)this.context.value(this.mapPlacement));
            boolean invertBlur = (Boolean)this.context.value((IAnimatableValue)this.invertBlur);
            Quality quality = this.context.getQuality();
            VideoBounds blurMapBounds = blurMap.getBounds();
            blurMap.setTextureFilter(quality == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : (quality == Quality.BEST && mapPlacement == MapPlacement.STRETCH && (blurMapBounds.width > bounds.width || blurMapBounds.height > bounds.height) ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR));
            mipmap = this.createBlurMipmap(source);
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("mipmap", 1));
            uniforms.add(new GLUniformData("blurMap", 2));
            uniforms.add(new GLUniformData("maximumBlur", (float)maximumBlur));
            if (mapPlacement != MapPlacement.STRETCH) {
                uniforms.add(new GLUniformData("size0", 2, this.toFloatBuffer(bounds.width, bounds.height)));
                uniforms.add(new GLUniformData("size1", 2, this.toFloatBuffer(blurMapBounds.width, blurMapBounds.height)));
                switch (mapPlacement) {
                    case TILE: {
                        blurMap.setTextureWrapMode(IVideoBuffer.TextureWrapMode.REPEAT);
                        break;
                    }
                    case MIRRORED_TILE: {
                        blurMap.setTextureWrapMode(IVideoBuffer.TextureWrapMode.MIRRORED_REPEAT);
                    }
                }
            }
            IShaderProgram program = this.getCompoundBlurProgram(mapPlacement, invertBlur);
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{source, mipmap, blurMap});
            return iVideoBuffer;
        }
        finally {
            if (blurMap != null) {
                blurMap.dispose();
            }
            if (mipmap != null) {
                mipmap.dispose();
            }
            if (source != null) {
                source.dispose();
            }
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private IVideoBuffer createBlurMipmap(IVideoBuffer source) {
        IVideoBuffer mipmap = null;
        IVideoBuffer tmpbuf = null;
        GL2 gl = this.context.getGL().getGL2();
        gl.glPushAttrib(278528);
        try {
            mipmap = this.support.createVideoBuffer(source.getBounds());
            this.support.copy(source, mipmap);
            mipmap.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
            gl.glActiveTexture(33984);
            int[] params = new int[2];
            int level = 0;
            while (true) {
                gl.glBindTexture(3553, mipmap.getTexture());
                gl.glGetTexLevelParameteriv(3553, level, 4096, params, 0);
                gl.glGetTexLevelParameteriv(3553, level, 4097, params, 1);
                VideoBounds b = new VideoBounds(params[0], params[1]);
                tmpbuf = this.support.createVideoBuffer(b);
                double radius = level == 0 ? 2 : (level == 1 ? 4 : 8);
                float[] kernel = this.blurSupport.createGaussianBlurKernel(radius);
                this.blurConvolution(gl, kernel, true, b, mipmap.getTexture(), level, tmpbuf.getTexture(), 0);
                this.blurConvolution(gl, kernel, false, b, tmpbuf.getTexture(), 0, mipmap.getTexture(), level);
                tmpbuf.dispose();
                tmpbuf = null;
                if (b.width == 1 && b.height == 1) break;
                ++level;
            }
            IVideoBuffer result = mipmap;
            mipmap = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            gl.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
            gl.glPopAttrib();
            if (mipmap != null) {
                mipmap.dispose();
            }
            if (tmpbuf != null) {
                tmpbuf.dispose();
            }
        }
    }

    private void blurConvolution(final GL2 gl, float[] kernel, boolean horz, final VideoBounds b, int srcTex, int srcLevel, int dstTex, int dstLevel) {
        int i;
        int ksize = kernel.length;
        float[] offset = new float[ksize * 2];
        if (horz) {
            i = 0;
            while (i < ksize) {
                offset[i * 2] = (float)(i - ksize / 2) / (float)b.width;
                offset[i * 2 + 1] = 0.0f;
                ++i;
            }
        } else {
            i = 0;
            while (i < ksize) {
                offset[i * 2] = 0.0f;
                offset[i * 2 + 1] = (float)(i - ksize / 2) / (float)b.height;
                ++i;
            }
        }
        gl.glFramebufferTexture2D(36160, 36064, 3553, dstTex, dstLevel);
        gl.glDrawBuffer(36064);
        gl.glBindTexture(3553, srcTex);
        final HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("ksize", ksize));
        uniforms.add(new GLUniformData("kernel[0]", 1, FloatBuffer.wrap(kernel)));
        uniforms.add(new GLUniformData("offset[0]", 2, FloatBuffer.wrap(offset)));
        uniforms.add(new GLUniformData("lod", (float)srcLevel));
        this.blurConvolutionProgram.useProgram(new Runnable(){

            public void run() {
                for (GLUniformData data : uniforms) {
                    data.setLocation(CompoundBlur.this.blurConvolutionProgram.getUniformLocation(data.getName()));
                    gl.glUniform(data);
                }
                CompoundBlur.this.support.ortho2D(b);
                CompoundBlur.this.support.quad2D(b, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
            }
        });
    }

    private IShaderProgram getCompoundBlurProgram(MapPlacement mapPlacement, boolean invert) {
        boolean stretch = mapPlacement == MapPlacement.STRETCH;
        String programName = String.valueOf(CompoundBlur.class.getName()) + (stretch ? ".STRETCH" : "") + (invert ? ".INVERT" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            String[] source = this.createCompoundBlurSource(stretch, invert);
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, null, source);
        }
        return program;
    }

    private String[] createCompoundBlurSource(boolean stretch, boolean invert) {
        return new String[]{stretch ? "#define STRETCH" : "", invert ? "#define INVERT" : "", "", "uniform sampler2D texture;", "uniform sampler2D mipmap;", "uniform sampler2D blurMap;", "uniform float maximumBlur;", "", "#ifndef STRETCH", "\tuniform vec2 size0;", "\tuniform vec2 size1;", "#endif", "", "const vec3 lumaVec = vec3(0.299, 0.587, 0.114);", "", "vec4 mixLod(sampler2D sampler, vec2 coord, float lod) {", "\tfloat lod1 = floor(lod);", "\treturn mix(texture2DLod(sampler, coord, lod1),", "\t\t\ttexture2DLod(sampler, coord, lod1+1.0), lod-lod1);", "}", "", "void main(void)", "{", "#ifdef STRETCH", "\tvec2 tc = gl_TexCoord[0].st;", "#else", "\tvec2 tc = ((gl_FragCoord.xy-0.5*size0) / size1) + vec2(0.5);", "#endif", "", "#ifdef INVERT", "\tfloat blur = (1.0-dot(texture2D(blurMap, tc).rgb, lumaVec)) * maximumBlur;", "#else", "\tfloat blur = dot(texture2D(blurMap, tc).rgb, lumaVec) * maximumBlur;", "#endif", "", "#ifndef STRETCH", "\ttc = gl_TexCoord[0].st;", "#endif", "", "\tif (blur > 32.0) {", "\t\tfloat lod = log2(0.25*blur) - 1.0;", "\t\tgl_FragColor = mixLod(mipmap, tc, lod);", "", "\t} else if (blur > 2.0) {", "\t\tfloat lod = 0.5*(log2(blur) - 1.0);", "\t\tgl_FragColor = mixLod(mipmap, tc, lod);", "", "\t} else if (blur > 0.0) {", "\t\tgl_FragColor = mix(texture2D(texture, tc),", "\t\t\t\t\t\ttexture2DLod(mipmap, tc, 0.0), 0.5*blur);", "", "\t} else {", "\t\tgl_FragColor = texture2D(texture, tc);", "\t}", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MapPlacement {
        STRETCH,
        CENTER,
        TILE,
        MIRRORED_TILE;

    }
}

