/*
 * Decompiled with CFR 0.152.
 */
package ca.uol.aig.fftpack;

class ComplexDoubleFFT_Mixed {
    ComplexDoubleFFT_Mixed() {
    }

    void passf2(int ido, int l1, double[] cc, double[] ch, double[] wtable, int offset, int isign) {
        int iw1 = offset;
        if (ido <= 2) {
            int k = 0;
            while (k < l1) {
                int ah = k * ido;
                int ac = 2 * k * ido;
                ch[ah] = cc[ac] + cc[ac + ido];
                ch[ah + ido * l1] = cc[ac] - cc[ac + ido];
                ch[ah + 1] = cc[ac + 1] + cc[ac + ido + 1];
                ch[ah + ido * l1 + 1] = cc[ac + 1] - cc[ac + ido + 1];
                ++k;
            }
        } else {
            int k = 0;
            while (k < l1) {
                int i = 0;
                while (i < ido - 1) {
                    int ah = i + k * ido;
                    int ac = i + 2 * k * ido;
                    ch[ah] = cc[ac] + cc[ac + ido];
                    double tr2 = cc[ac] - cc[ac + ido];
                    ch[ah + 1] = cc[ac + 1] + cc[ac + 1 + ido];
                    double ti2 = cc[ac + 1] - cc[ac + 1 + ido];
                    ch[ah + l1 * ido + 1] = wtable[i + iw1] * ti2 + (double)isign * wtable[i + 1 + iw1] * tr2;
                    ch[ah + l1 * ido] = wtable[i + iw1] * tr2 - (double)isign * wtable[i + 1 + iw1] * ti2;
                    i += 2;
                }
                ++k;
            }
        }
    }

    void passf3(int ido, int l1, double[] cc, double[] ch, double[] wtable, int offset, int isign) {
        int iw1 = offset;
        int iw2 = iw1 + ido;
        if (ido == 2) {
            int k = 1;
            while (k <= l1) {
                int ac = (3 * k - 2) * ido;
                double tr2 = cc[ac] + cc[ac + ido];
                double cr2 = cc[ac - ido] + -0.5 * tr2;
                int ah = (k - 1) * ido;
                ch[ah] = cc[ac - ido] + tr2;
                double ti2 = cc[ac + 1] + cc[ac + ido + 1];
                double ci2 = cc[ac - ido + 1] + -0.5 * ti2;
                ch[ah + 1] = cc[ac - ido + 1] + ti2;
                double cr3 = (double)isign * 0.866025403784439 * (cc[ac] - cc[ac + ido]);
                double ci3 = (double)isign * 0.866025403784439 * (cc[ac + 1] - cc[ac + ido + 1]);
                ch[ah + l1 * ido] = cr2 - ci3;
                ch[ah + 2 * l1 * ido] = cr2 + ci3;
                ch[ah + l1 * ido + 1] = ci2 + cr3;
                ch[ah + 2 * l1 * ido + 1] = ci2 - cr3;
                ++k;
            }
        } else {
            int k = 1;
            while (k <= l1) {
                int i = 0;
                while (i < ido - 1) {
                    int ac = i + (3 * k - 2) * ido;
                    double tr2 = cc[ac] + cc[ac + ido];
                    double cr2 = cc[ac - ido] + -0.5 * tr2;
                    int ah = i + (k - 1) * ido;
                    ch[ah] = cc[ac - ido] + tr2;
                    double ti2 = cc[ac + 1] + cc[ac + ido + 1];
                    double ci2 = cc[ac - ido + 1] + -0.5 * ti2;
                    ch[ah + 1] = cc[ac - ido + 1] + ti2;
                    double cr3 = (double)isign * 0.866025403784439 * (cc[ac] - cc[ac + ido]);
                    double ci3 = (double)isign * 0.866025403784439 * (cc[ac + 1] - cc[ac + ido + 1]);
                    double dr2 = cr2 - ci3;
                    double dr3 = cr2 + ci3;
                    double di2 = ci2 + cr3;
                    double di3 = ci2 - cr3;
                    ch[ah + l1 * ido + 1] = wtable[i + iw1] * di2 + (double)isign * wtable[i + 1 + iw1] * dr2;
                    ch[ah + l1 * ido] = wtable[i + iw1] * dr2 - (double)isign * wtable[i + 1 + iw1] * di2;
                    ch[ah + 2 * l1 * ido + 1] = wtable[i + iw2] * di3 + (double)isign * wtable[i + 1 + iw2] * dr3;
                    ch[ah + 2 * l1 * ido] = wtable[i + iw2] * dr3 - (double)isign * wtable[i + 1 + iw2] * di3;
                    i += 2;
                }
                ++k;
            }
        }
    }

    void passf4(int ido, int l1, double[] cc, double[] ch, double[] wtable, int offset, int isign) {
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        if (ido == 2) {
            int k = 0;
            while (k < l1) {
                int ac = 4 * k * ido + 1;
                double ti1 = cc[ac] - cc[ac + 2 * ido];
                double ti2 = cc[ac] + cc[ac + 2 * ido];
                double tr4 = cc[ac + 3 * ido] - cc[ac + ido];
                double ti3 = cc[ac + ido] + cc[ac + 3 * ido];
                double tr1 = cc[ac - 1] - cc[ac + 2 * ido - 1];
                double tr2 = cc[ac - 1] + cc[ac + 2 * ido - 1];
                double ti4 = cc[ac + ido - 1] - cc[ac + 3 * ido - 1];
                double tr3 = cc[ac + ido - 1] + cc[ac + 3 * ido - 1];
                int ah = k * ido;
                ch[ah] = tr2 + tr3;
                ch[ah + 2 * l1 * ido] = tr2 - tr3;
                ch[ah + 1] = ti2 + ti3;
                ch[ah + 2 * l1 * ido + 1] = ti2 - ti3;
                ch[ah + l1 * ido] = tr1 + (double)isign * tr4;
                ch[ah + 3 * l1 * ido] = tr1 - (double)isign * tr4;
                ch[ah + l1 * ido + 1] = ti1 + (double)isign * ti4;
                ch[ah + 3 * l1 * ido + 1] = ti1 - (double)isign * ti4;
                ++k;
            }
        } else {
            int k = 0;
            while (k < l1) {
                int i = 0;
                while (i < ido - 1) {
                    int ac = i + 1 + 4 * k * ido;
                    double ti1 = cc[ac] - cc[ac + 2 * ido];
                    double ti2 = cc[ac] + cc[ac + 2 * ido];
                    double ti3 = cc[ac + ido] + cc[ac + 3 * ido];
                    double tr4 = cc[ac + 3 * ido] - cc[ac + ido];
                    double tr1 = cc[ac - 1] - cc[ac + 2 * ido - 1];
                    double tr2 = cc[ac - 1] + cc[ac + 2 * ido - 1];
                    double ti4 = cc[ac + ido - 1] - cc[ac + 3 * ido - 1];
                    double tr3 = cc[ac + ido - 1] + cc[ac + 3 * ido - 1];
                    int ah = i + k * ido;
                    ch[ah] = tr2 + tr3;
                    double cr3 = tr2 - tr3;
                    ch[ah + 1] = ti2 + ti3;
                    double ci3 = ti2 - ti3;
                    double cr2 = tr1 + (double)isign * tr4;
                    double cr4 = tr1 - (double)isign * tr4;
                    double ci2 = ti1 + (double)isign * ti4;
                    double ci4 = ti1 - (double)isign * ti4;
                    ch[ah + l1 * ido] = wtable[i + iw1] * cr2 - (double)isign * wtable[i + 1 + iw1] * ci2;
                    ch[ah + l1 * ido + 1] = wtable[i + iw1] * ci2 + (double)isign * wtable[i + 1 + iw1] * cr2;
                    ch[ah + 2 * l1 * ido] = wtable[i + iw2] * cr3 - (double)isign * wtable[i + 1 + iw2] * ci3;
                    ch[ah + 2 * l1 * ido + 1] = wtable[i + iw2] * ci3 + (double)isign * wtable[i + 1 + iw2] * cr3;
                    ch[ah + 3 * l1 * ido] = wtable[i + iw3] * cr4 - (double)isign * wtable[i + 1 + iw3] * ci4;
                    ch[ah + 3 * l1 * ido + 1] = wtable[i + iw3] * ci4 + (double)isign * wtable[i + 1 + iw3] * cr4;
                    i += 2;
                }
                ++k;
            }
        }
    }

    void passf5(int ido, int l1, double[] cc, double[] ch, double[] wtable, int offset, int isign) {
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int iw4 = iw3 + ido;
        if (ido == 2) {
            int k = 1;
            while (k <= l1) {
                int ac = (5 * k - 4) * ido + 1;
                double ti5 = cc[ac] - cc[ac + 3 * ido];
                double ti2 = cc[ac] + cc[ac + 3 * ido];
                double ti4 = cc[ac + ido] - cc[ac + 2 * ido];
                double ti3 = cc[ac + ido] + cc[ac + 2 * ido];
                double tr5 = cc[ac - 1] - cc[ac + 3 * ido - 1];
                double tr2 = cc[ac - 1] + cc[ac + 3 * ido - 1];
                double tr4 = cc[ac + ido - 1] - cc[ac + 2 * ido - 1];
                double tr3 = cc[ac + ido - 1] + cc[ac + 2 * ido - 1];
                int ah = (k - 1) * ido;
                ch[ah] = cc[ac - ido - 1] + tr2 + tr3;
                ch[ah + 1] = cc[ac - ido] + ti2 + ti3;
                double cr2 = cc[ac - ido - 1] + 0.309016994374947 * tr2 + -0.809016994374947 * tr3;
                double ci2 = cc[ac - ido] + 0.309016994374947 * ti2 + -0.809016994374947 * ti3;
                double cr3 = cc[ac - ido - 1] + -0.809016994374947 * tr2 + 0.309016994374947 * tr3;
                double ci3 = cc[ac - ido] + -0.809016994374947 * ti2 + 0.309016994374947 * ti3;
                double cr5 = (double)isign * (0.951056516295154 * tr5 + 0.587785252292473 * tr4);
                double ci5 = (double)isign * (0.951056516295154 * ti5 + 0.587785252292473 * ti4);
                double cr4 = (double)isign * (0.587785252292473 * tr5 - 0.951056516295154 * tr4);
                double ci4 = (double)isign * (0.587785252292473 * ti5 - 0.951056516295154 * ti4);
                ch[ah + l1 * ido] = cr2 - ci5;
                ch[ah + 4 * l1 * ido] = cr2 + ci5;
                ch[ah + l1 * ido + 1] = ci2 + cr5;
                ch[ah + 2 * l1 * ido + 1] = ci3 + cr4;
                ch[ah + 2 * l1 * ido] = cr3 - ci4;
                ch[ah + 3 * l1 * ido] = cr3 + ci4;
                ch[ah + 3 * l1 * ido + 1] = ci3 - cr4;
                ch[ah + 4 * l1 * ido + 1] = ci2 - cr5;
                ++k;
            }
        } else {
            int k = 1;
            while (k <= l1) {
                int i = 0;
                while (i < ido - 1) {
                    int ac = i + 1 + (k * 5 - 4) * ido;
                    double ti5 = cc[ac] - cc[ac + 3 * ido];
                    double ti2 = cc[ac] + cc[ac + 3 * ido];
                    double ti4 = cc[ac + ido] - cc[ac + 2 * ido];
                    double ti3 = cc[ac + ido] + cc[ac + 2 * ido];
                    double tr5 = cc[ac - 1] - cc[ac + 3 * ido - 1];
                    double tr2 = cc[ac - 1] + cc[ac + 3 * ido - 1];
                    double tr4 = cc[ac + ido - 1] - cc[ac + 2 * ido - 1];
                    double tr3 = cc[ac + ido - 1] + cc[ac + 2 * ido - 1];
                    int ah = i + (k - 1) * ido;
                    ch[ah] = cc[ac - ido - 1] + tr2 + tr3;
                    ch[ah + 1] = cc[ac - ido] + ti2 + ti3;
                    double cr2 = cc[ac - ido - 1] + 0.309016994374947 * tr2 + -0.809016994374947 * tr3;
                    double ci2 = cc[ac - ido] + 0.309016994374947 * ti2 + -0.809016994374947 * ti3;
                    double cr3 = cc[ac - ido - 1] + -0.809016994374947 * tr2 + 0.309016994374947 * tr3;
                    double ci3 = cc[ac - ido] + -0.809016994374947 * ti2 + 0.309016994374947 * ti3;
                    double cr5 = (double)isign * (0.951056516295154 * tr5 + 0.587785252292473 * tr4);
                    double ci5 = (double)isign * (0.951056516295154 * ti5 + 0.587785252292473 * ti4);
                    double cr4 = (double)isign * (0.587785252292473 * tr5 - 0.951056516295154 * tr4);
                    double ci4 = (double)isign * (0.587785252292473 * ti5 - 0.951056516295154 * ti4);
                    double dr3 = cr3 - ci4;
                    double dr4 = cr3 + ci4;
                    double di3 = ci3 + cr4;
                    double di4 = ci3 - cr4;
                    double dr5 = cr2 + ci5;
                    double dr2 = cr2 - ci5;
                    double di5 = ci2 - cr5;
                    double di2 = ci2 + cr5;
                    ch[ah + l1 * ido] = wtable[i + iw1] * dr2 - (double)isign * wtable[i + 1 + iw1] * di2;
                    ch[ah + l1 * ido + 1] = wtable[i + iw1] * di2 + (double)isign * wtable[i + 1 + iw1] * dr2;
                    ch[ah + 2 * l1 * ido] = wtable[i + iw2] * dr3 - (double)isign * wtable[i + 1 + iw2] * di3;
                    ch[ah + 2 * l1 * ido + 1] = wtable[i + iw2] * di3 + (double)isign * wtable[i + 1 + iw2] * dr3;
                    ch[ah + 3 * l1 * ido] = wtable[i + iw3] * dr4 - (double)isign * wtable[i + 1 + iw3] * di4;
                    ch[ah + 3 * l1 * ido + 1] = wtable[i + iw3] * di4 + (double)isign * wtable[i + 1 + iw3] * dr4;
                    ch[ah + 4 * l1 * ido] = wtable[i + iw4] * dr5 - (double)isign * wtable[i + 1 + iw4] * di5;
                    ch[ah + 4 * l1 * ido + 1] = wtable[i + iw4] * di5 + (double)isign * wtable[i + 1 + iw4] * dr5;
                    i += 2;
                }
                ++k;
            }
        }
    }

    void passfg(int[] nac, int ido, int ip, int l1, int idl1, double[] cc, double[] c1, double[] c2, double[] ch, double[] ch2, double[] wtable, int offset, int isign) {
        int ik;
        int i;
        int k;
        int jc;
        int j;
        int iw1 = offset;
        int idot = ido / 2;
        int ipph = (ip + 1) / 2;
        int idp = ip * ido;
        if (ido >= l1) {
            j = 1;
            while (j < ipph) {
                jc = ip - j;
                k = 0;
                while (k < l1) {
                    i = 0;
                    while (i < ido) {
                        ch[i + (k + j * l1) * ido] = cc[i + (j + k * ip) * ido] + cc[i + (jc + k * ip) * ido];
                        ch[i + (k + jc * l1) * ido] = cc[i + (j + k * ip) * ido] - cc[i + (jc + k * ip) * ido];
                        ++i;
                    }
                    ++k;
                }
                ++j;
            }
            k = 0;
            while (k < l1) {
                i = 0;
                while (i < ido) {
                    ch[i + k * ido] = cc[i + k * ip * ido];
                    ++i;
                }
                ++k;
            }
        } else {
            j = 1;
            while (j < ipph) {
                jc = ip - j;
                i = 0;
                while (i < ido) {
                    k = 0;
                    while (k < l1) {
                        ch[i + (k + j * l1) * ido] = cc[i + (j + k * ip) * ido] + cc[i + (jc + k * ip) * ido];
                        ch[i + (k + jc * l1) * ido] = cc[i + (j + k * ip) * ido] - cc[i + (jc + k * ip) * ido];
                        ++k;
                    }
                    ++i;
                }
                ++j;
            }
            i = 0;
            while (i < ido) {
                k = 0;
                while (k < l1) {
                    ch[i + k * ido] = cc[i + k * ip * ido];
                    ++k;
                }
                ++i;
            }
        }
        int idl = 2 - ido;
        int inc = 0;
        int l = 1;
        while (l < ipph) {
            int lc = ip - l;
            idl += ido;
            ik = 0;
            while (ik < idl1) {
                c2[ik + l * idl1] = ch2[ik] + wtable[idl - 2 + iw1] * ch2[ik + idl1];
                c2[ik + lc * idl1] = (double)isign * wtable[idl - 1 + iw1] * ch2[ik + (ip - 1) * idl1];
                ++ik;
            }
            int idlj = idl;
            inc += ido;
            j = 2;
            while (j < ipph) {
                jc = ip - j;
                if ((idlj += inc) > idp) {
                    idlj -= idp;
                }
                double war = wtable[idlj - 2 + iw1];
                double wai = wtable[idlj - 1 + iw1];
                ik = 0;
                while (ik < idl1) {
                    int n = ik + l * idl1;
                    c2[n] = c2[n] + war * ch2[ik + j * idl1];
                    int n2 = ik + lc * idl1;
                    c2[n2] = c2[n2] + (double)isign * wai * ch2[ik + jc * idl1];
                    ++ik;
                }
                ++j;
            }
            ++l;
        }
        j = 1;
        while (j < ipph) {
            ik = 0;
            while (ik < idl1) {
                int n = ik;
                ch2[n] = ch2[n] + ch2[ik + j * idl1];
                ++ik;
            }
            ++j;
        }
        j = 1;
        while (j < ipph) {
            jc = ip - j;
            ik = 1;
            while (ik < idl1) {
                ch2[ik - 1 + j * idl1] = c2[ik - 1 + j * idl1] - c2[ik + jc * idl1];
                ch2[ik - 1 + jc * idl1] = c2[ik - 1 + j * idl1] + c2[ik + jc * idl1];
                ch2[ik + j * idl1] = c2[ik + j * idl1] + c2[ik - 1 + jc * idl1];
                ch2[ik + jc * idl1] = c2[ik + j * idl1] - c2[ik - 1 + jc * idl1];
                ik += 2;
            }
            ++j;
        }
        nac[0] = 1;
        if (ido == 2) {
            return;
        }
        nac[0] = 0;
        ik = 0;
        while (ik < idl1) {
            c2[ik] = ch2[ik];
            ++ik;
        }
        j = 1;
        while (j < ip) {
            k = 0;
            while (k < l1) {
                c1[(k + j * l1) * ido + 0] = ch[(k + j * l1) * ido + 0];
                c1[(k + j * l1) * ido + 1] = ch[(k + j * l1) * ido + 1];
                ++k;
            }
            ++j;
        }
        if (idot <= l1) {
            int idij = 0;
            j = 1;
            while (j < ip) {
                idij += 2;
                i = 3;
                while (i < ido) {
                    idij += 2;
                    k = 0;
                    while (k < l1) {
                        c1[i - 1 + (k + j * l1) * ido] = wtable[idij - 2 + iw1] * ch[i - 1 + (k + j * l1) * ido] - (double)isign * wtable[idij - 1 + iw1] * ch[i + (k + j * l1) * ido];
                        c1[i + (k + j * l1) * ido] = wtable[idij - 2 + iw1] * ch[i + (k + j * l1) * ido] + (double)isign * wtable[idij - 1 + iw1] * ch[i - 1 + (k + j * l1) * ido];
                        ++k;
                    }
                    i += 2;
                }
                ++j;
            }
        } else {
            int idj = 2 - ido;
            j = 1;
            while (j < ip) {
                idj += ido;
                k = 0;
                while (k < l1) {
                    int idij = idj;
                    i = 3;
                    while (i < ido) {
                        c1[i - 1 + (k + j * l1) * ido] = wtable[(idij += 2) - 2 + iw1] * ch[i - 1 + (k + j * l1) * ido] - (double)isign * wtable[idij - 1 + iw1] * ch[i + (k + j * l1) * ido];
                        c1[i + (k + j * l1) * ido] = wtable[idij - 2 + iw1] * ch[i + (k + j * l1) * ido] + (double)isign * wtable[idij - 1 + iw1] * ch[i - 1 + (k + j * l1) * ido];
                        i += 2;
                    }
                    ++k;
                }
                ++j;
            }
        }
    }

    void cfftf1(int n, double[] c, double[] wtable, int isign) {
        int[] nac = new int[1];
        double[] ch = new double[2 * n];
        int iw1 = 2 * n;
        int iw2 = 4 * n;
        System.arraycopy(wtable, 0, ch, 0, 2 * n);
        nac[0] = 0;
        int nf = (int)wtable[1 + iw2];
        int na = 0;
        int l1 = 1;
        int iw = iw1;
        int k1 = 2;
        while (k1 <= nf + 1) {
            int ip = (int)wtable[k1 + iw2];
            int l2 = ip * l1;
            int ido = n / l2;
            int idot = ido + ido;
            int idl1 = idot * l1;
            if (ip == 4) {
                if (na == 0) {
                    this.passf4(idot, l1, c, ch, wtable, iw, isign);
                } else {
                    this.passf4(idot, l1, ch, c, wtable, iw, isign);
                }
                na = 1 - na;
            } else if (ip == 2) {
                if (na == 0) {
                    this.passf2(idot, l1, c, ch, wtable, iw, isign);
                } else {
                    this.passf2(idot, l1, ch, c, wtable, iw, isign);
                }
                na = 1 - na;
            } else if (ip == 3) {
                if (na == 0) {
                    this.passf3(idot, l1, c, ch, wtable, iw, isign);
                } else {
                    this.passf3(idot, l1, ch, c, wtable, iw, isign);
                }
                na = 1 - na;
            } else if (ip == 5) {
                if (na == 0) {
                    this.passf5(idot, l1, c, ch, wtable, iw, isign);
                } else {
                    this.passf5(idot, l1, ch, c, wtable, iw, isign);
                }
                na = 1 - na;
            } else {
                if (na == 0) {
                    this.passfg(nac, idot, ip, l1, idl1, c, c, c, ch, ch, wtable, iw, isign);
                } else {
                    this.passfg(nac, idot, ip, l1, idl1, ch, ch, ch, c, c, wtable, iw, isign);
                }
                if (nac[0] != 0) {
                    na = 1 - na;
                }
            }
            l1 = l2;
            iw += (ip - 1) * idot;
            ++k1;
        }
        if (na == 0) {
            return;
        }
        int i = 0;
        while (i < 2 * n) {
            c[i] = ch[i];
            ++i;
        }
    }

    void cfftf(int n, double[] c, double[] wtable) {
        this.cfftf1(n, c, wtable, -1);
    }

    void cfftb(int n, double[] c, double[] wtable) {
        this.cfftf1(n, c, wtable, 1);
    }

    void cffti1(int n, double[] wtable) {
        int i;
        int[] ntryh = new int[]{3, 4, 2, 5};
        int ntry = 0;
        int nl = n;
        int nf = 0;
        int j = 0;
        block0: while (true) {
            ntry = ++j <= 4 ? ntryh[j - 1] : (ntry += 2);
            do {
                int nq;
                int nr;
                if ((nr = nl - ntry * (nq = nl / ntry)) != 0) continue block0;
                wtable[++nf + 1 + 4 * n] = ntry;
                nl = nq;
                if (ntry != 2 || nf == 1) continue;
                i = 2;
                while (i <= nf) {
                    int ib = nf - i + 2;
                    wtable[ib + 1 + 4 * n] = wtable[ib + 4 * n];
                    ++i;
                }
                wtable[2 + 4 * n] = 2.0;
            } while (nl != 1);
            break;
        }
        wtable[0 + 4 * n] = n;
        wtable[1 + 4 * n] = nf;
        double argh = Math.PI * 2 / (double)n;
        i = 1;
        int l1 = 1;
        int k1 = 1;
        while (k1 <= nf) {
            int ip = (int)wtable[k1 + 1 + 4 * n];
            int ld = 0;
            int l2 = l1 * ip;
            int ido = n / l2;
            int idot = ido + ido + 2;
            int ipm = ip - 1;
            j = 1;
            while (j <= ipm) {
                int i1 = i;
                wtable[i - 1 + 2 * n] = 1.0;
                wtable[i + 2 * n] = 0.0;
                double fi = 0.0;
                double argld = (double)(ld += l1) * argh;
                int ii = 4;
                while (ii <= idot) {
                    double arg = (fi += 1.0) * argld;
                    wtable[(i += 2) - 1 + 2 * n] = Math.cos(arg);
                    wtable[i + 2 * n] = Math.sin(arg);
                    ii += 2;
                }
                if (ip > 5) {
                    wtable[i1 - 1 + 2 * n] = wtable[i - 1 + 2 * n];
                    wtable[i1 + 2 * n] = wtable[i + 2 * n];
                }
                ++j;
            }
            l1 = l2;
            ++k1;
        }
    }

    void cffti(int n, double[] wtable) {
        if (n == 1) {
            return;
        }
        this.cffti1(n, wtable);
    }
}

