/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.api;

import ch.kuramo.javie.api.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AudioMode {
    STEREO_48KHZ_INT16(2, 48000, DataType.SHORT),
    STEREO_48KHZ_INT32(2, 48000, DataType.INT),
    STEREO_48KHZ_FLOAT32(2, 48000, DataType.FLOAT),
    STEREO_96KHZ_INT16(2, 96000, DataType.SHORT),
    STEREO_96KHZ_INT32(2, 96000, DataType.INT),
    STEREO_96KHZ_FLOAT32(2, 96000, DataType.FLOAT);

    public final int channels;
    public final int sampleRate;
    public final Time sampleDuration;
    public final int sampleSize;
    public final int frameSize;
    public final DataType dataType;

    private AudioMode(int channels, int sampleRate, DataType dataType) {
        this.channels = channels;
        this.sampleRate = sampleRate;
        this.sampleDuration = new Time(1L, sampleRate);
        this.sampleSize = dataType == DataType.SHORT ? 2 : 4;
        this.frameSize = channels * this.sampleSize;
        this.dataType = dataType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        SHORT,
        INT,
        FLOAT;

    }
}

