/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.voodoo2javie;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Voodoo2Javie {
    private static final Logger logger = LoggerFactory.getLogger(Voodoo2Javie.class);
    private List<String> data;
    private int width;
    private int height;

    Voodoo2Javie() {
    }

    boolean readFile(final File file, IRunnableContext rc) {
        block4: {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Voodoo2Javie.this.readFile(file, monitor);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            logger.info("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u3092\u958b\u59cb\u3057\u307e\u3057\u305f...");
            rc.run(true, true, runnable);
            if (this.data == null) break block4;
            logger.info("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f");
            return true;
        }
        try {
            logger.info("\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093");
            return false;
        }
        catch (InterruptedException interruptedException) {
            logger.info("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f");
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            logger.error("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", t != null ? t : ex);
        }
        return false;
    }

    private void readFile(File file, IProgressMonitor monitor) throws IOException {
        List data = Util.newList();
        monitor.beginTask("\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...", -1);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "US-ASCII"));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#timeindex ")) {
                    int timeindex = Integer.parseInt(line.substring(11));
                    if (timeindex != data.size()) {
                        data.clear();
                        logger.error("\u30c7\u30fc\u30bf\u304c\u58ca\u308c\u3066\u3044\u307e\u3059\u3002");
                        break;
                    }
                    data.add(reader.readLine());
                    continue;
                }
                if (data.size() > 0) break;
            }
            if (data.isEmpty()) {
                this.data = null;
                this.width = 0;
                this.height = 0;
            } else {
                this.data = data;
                String[] array = ((String)data.get(0)).split("\\s+");
                this.width = Integer.parseInt(array[16]);
                this.height = Integer.parseInt(array[17]);
            }
        }
        finally {
            monitor.done();
            if (reader != null) {
                reader.close();
            }
        }
    }

    void createCamera(double scale, Time frameDuration, Project project, ProjectElementFactory elementFactory, IProgressMonitor monitor) throws InterruptedException {
        if (this.data == null) {
            throw new IllegalStateException();
        }
        monitor.beginTask("\u30ab\u30e1\u30e9\u30c7\u30fc\u30bf\u3092\u51e6\u7406\u4e2d...", this.data.size());
        try {
            Size2i size = new Size2i((int)Math.round((double)this.width * scale), (int)Math.round((double)this.height * scale));
            Time duration = Time.fromFrameNumber((long)this.data.size(), (Time)frameDuration);
            LayerComposition layerComp = elementFactory.newLayerComposition(ColorMode.RGBA8, size, frameDuration, duration);
            CompositionItem compItem = elementFactory.newCompositionItem((Composition)layerComp);
            compItem.setName("Voodoo Camera");
            project.getCompositions().add(layerComp);
            project.getItems().add(compItem);
            CameraLayer cameraLayer = elementFactory.newCameraLayer();
            Time time0 = Time.fromFrameNumber((long)0L, (Time)frameDuration);
            cameraLayer.setStartTime(time0);
            cameraLayer.setInPoint(time0);
            cameraLayer.setOutPoint(duration);
            String[] array = this.data.get(0).split("\\s+");
            double sx = Double.parseDouble(array[14]);
            double f = Double.parseDouble(array[20]);
            double zoom = f / sx * scale;
            cameraLayer.getZoom().reset((Object)zoom);
            double x = Double.parseDouble(array[0]) / sx;
            double y = Double.parseDouble(array[1]) / sx;
            double z = Double.parseDouble(array[2]) / sx;
            cameraLayer.getPosition().reset((Object)new Vec3d(x, y, z));
            cameraLayer.getPointOfInterest().reset((Object)new Vec3d(x, y, z + zoom));
            cameraLayer.getOrientation().reset((Object)this.calcOrientation(array));
            cameraLayer.setName("Voodoo Camera");
            layerComp.getLayers().add(cameraLayer);
            ListIterator<String> it = this.data.listIterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException("canceled");
                }
                int index = it.nextIndex();
                Time time = Time.fromFrameNumber((long)index, (Time)frameDuration);
                array = it.next().split("\\s+");
                sx = Double.parseDouble(array[14]);
                f = Double.parseDouble(array[20]);
                zoom = f / sx * scale;
                cameraLayer.getZoom().putKeyframe(time, (Object)zoom, Interpolation.LINEAR);
                x = Double.parseDouble(array[0]) / sx;
                y = Double.parseDouble(array[1]) / sx;
                z = Double.parseDouble(array[2]) / sx;
                cameraLayer.getPosition().putKeyframe(time, (Object)new Vec3d(x, y, z), Interpolation.LINEAR);
                cameraLayer.getPointOfInterest().putKeyframe(time, (Object)new Vec3d(x, y, z + zoom), Interpolation.LINEAR);
                cameraLayer.getOrientation().putKeyframe(time, (Object)this.calcOrientation(array), Interpolation.LINEAR);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private Vec3d calcOrientation(String[] array) {
        double z;
        double y;
        double x;
        double m00 = Double.parseDouble(array[22]);
        double m01 = Double.parseDouble(array[23]);
        double m10 = Double.parseDouble(array[25]);
        double m11 = Double.parseDouble(array[26]);
        double m20 = Double.parseDouble(array[3]);
        double m21 = Double.parseDouble(array[4]);
        double m22 = Double.parseDouble(array[5]);
        if (m20 == 1.0) {
            x = 0.0;
            y = -1.5707963267948966;
            z = -Math.atan2(m01, m11);
        } else if (m20 == -1.0) {
            x = 0.0;
            y = 1.5707963267948966;
            z = -Math.atan2(m01, m11);
        } else {
            x = Math.atan2(m21, m22);
            y = Math.asin(-m20);
            z = Math.atan2(m10, m00);
        }
        return new Vec3d(Math.toDegrees(-x), Math.toDegrees(-y), Math.toDegrees(-z));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameCount() {
        return this.data != null ? this.data.size() : 0;
    }
}

