/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie2mmd;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.output.Javie2MMDOutput;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Javie2MMDWizardPage
extends WizardPage {
    private final Size2i compSize;
    private File defaultFile;
    private File file;
    private Text scaleText;
    private Combo originCombo;
    private Text xoffText;
    private Text yoffText;
    private Text zoffText;
    private Combo roundingCombo;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Javie2MMDWizardPage.this.doValidate();
        }
    };
    private final SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Javie2MMDWizardPage.this.doValidate();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Javie2MMDWizardPage.this.doValidate();
        }
    };

    public Javie2MMDWizardPage(Size2i compSize, File defaultFile) {
        super("Javie2MMDWizardPage", "\u66f8\u304d\u51fa\u3057\u8a2d\u5b9a", null);
        this.compSize = compSize;
        this.defaultFile = defaultFile;
    }

    public void createControl(Composite parent) {
        GridBuilder gb = new GridBuilder(parent, 1, false);
        ((GridLayout)gb.getComposite().getLayout()).verticalSpacing = 0;
        this.createFileGroup(gb);
        gb.size(10, 10).composite(0);
        this.createMainGroup(gb);
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.setControl((Control)grid);
        this.doValidate();
    }

    private void createFileGroup(GridBuilder gb) {
        Group group = gb.hAlign(4).hGrab().group(0, null);
        group.setLayout((Layout)new FillLayout(256));
        GridBuilder gb2 = new GridBuilder((Composite)group, 2, false);
        GridLayout layout = (GridLayout)gb2.getComposite().getLayout();
        layout.marginWidth = 15;
        gb2.hSpan(1).hAlign(131072).label(0, "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb:");
        final Text fileText = gb2.hSpan(1).hAlign(4).hGrab().text(8, "");
        Button fileButton = gb2.hSpan(2).hAlign(131072).button(8, "\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a...");
        fileText.setBackground(fileText.getDisplay().getSystemColor(1));
        fileButton.setFocus();
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File newFile = Javie2MMDWizardPage.this.showSaveDialog(Javie2MMDWizardPage.this.defaultFile.getParentFile(), Javie2MMDWizardPage.this.defaultFile.getName());
                if (newFile != null) {
                    File file = newFile;
                    Javie2MMDWizardPage.this.file = file;
                    Javie2MMDWizardPage.this.defaultFile = file;
                    fileText.setText(newFile.getAbsolutePath());
                    fileText.setFocus();
                    fileText.selectAll();
                    Javie2MMDWizardPage.this.doValidate();
                }
            }
        });
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void createMainGroup(GridBuilder gb) {
        String[] originComboItems = new String[]{"\u539f\u70b9", "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306e\u4e2d\u5fc3", "\u30ab\u30b9\u30bf\u30e0"};
        String[] roundingComboItems = new String[]{"\u56db\u6368\u4e94\u5165", "\u5207\u308a\u6368\u3066", "\u5207\u308a\u4e0a\u3052"};
        Group group = gb.hAlign(4).hGrab().group(0, null);
        group.setLayout((Layout)new FillLayout(256));
        GridBuilder gb2 = new GridBuilder((Composite)group, 9, false);
        GridLayout layout = (GridLayout)gb2.getComposite().getLayout();
        layout.marginWidth = 15;
        gb2.hSpan(1).hAlign(131072).label(0, "\u30b9\u30b1\u30fc\u30eb:");
        this.scaleText = gb2.hSpan(2).hAlign(4).width(70).text(2048, "5");
        gb2.hSpan(6).hAlign(16384).label(0, "%");
        gb2.hSpan(1).hAlign(131072).label(0, "\u4f4d\u7f6e\u306e\u57fa\u6e96:");
        this.originCombo = gb2.hSpan(8).hAlign(16384).combo(8, originComboItems, originComboItems[1]);
        gb2.hSpan(1).size(10, 10).composite(0);
        gb2.hSpan(1).hAlign(16384).label(0, "x =");
        this.xoffText = gb2.hSpan(2).hAlign(4).width(70).text(2048, "");
        gb2.hSpan(1).hAlign(16384).label(0, "  y =");
        this.yoffText = gb2.hSpan(1).hAlign(4).width(70).text(2048, "");
        gb2.hSpan(1).hAlign(16384).label(0, "  z =");
        this.zoffText = gb2.hSpan(1).hAlign(4).width(70).text(2048, "");
        gb2.hSpan(1).hAlign(16384).label(0, "");
        gb2.hSpan(1).hAlign(131072).label(0, "\u8996\u91ce\u89d2\u306e\u4e38\u3081:");
        this.roundingCombo = gb2.hSpan(8).hAlign(16384).combo(8, roundingComboItems, roundingComboItems[0]);
        this.scaleText.addModifyListener(this.modifyListener);
        this.originCombo.addSelectionListener(this.selectionListener);
        this.xoffText.addModifyListener(this.modifyListener);
        this.yoffText.addModifyListener(this.modifyListener);
        this.zoffText.addModifyListener(this.modifyListener);
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private File showSaveDialog(File folder, String fileName) {
        String[] filterNames = new String[]{"VMD \u30d5\u30a1\u30a4\u30eb", "\u3059\u3079\u3066\u306e\u30d5\u30a1\u30a4\u30eb"};
        String[] filterExtensions = new String[]{"*.vmd", "*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterExtensions[filterExtensions.length - 1] = "*.*";
        }
        FileDialog dialog = new FileDialog(this.getShell(), 0x10002000);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(folder != null ? folder.getAbsolutePath() : null);
        dialog.setFileName(fileName);
        dialog.setOverwrite(true);
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }

    private void doValidate() {
        double scale;
        this.setPageComplete(false);
        String scaleStr = this.scaleText.getText().trim();
        try {
            scale = Double.parseDouble(scaleStr);
        }
        catch (NumberFormatException numberFormatException) {
            scale = 0.0;
        }
        this.xoffText.removeModifyListener(this.modifyListener);
        this.yoffText.removeModifyListener(this.modifyListener);
        this.zoffText.removeModifyListener(this.modifyListener);
        switch (this.originCombo.getSelectionIndex()) {
            case 0: {
                this.xoffText.setEnabled(false);
                this.xoffText.setText("0");
                this.yoffText.setEnabled(false);
                this.yoffText.setText("0");
                this.zoffText.setEnabled(false);
                this.zoffText.setText("0");
                break;
            }
            case 1: {
                this.xoffText.setEnabled(false);
                this.xoffText.setText(String.valueOf((double)this.compSize.width * 0.5));
                this.yoffText.setEnabled(false);
                this.yoffText.setText(String.valueOf((double)this.compSize.height * 0.5));
                this.zoffText.setEnabled(false);
                this.zoffText.setText("0");
                break;
            }
            case 2: {
                boolean focus = !this.xoffText.isEnabled();
                this.xoffText.setEnabled(true);
                this.yoffText.setEnabled(true);
                this.zoffText.setEnabled(true);
                if (!focus) break;
                this.xoffText.setFocus();
            }
        }
        this.xoffText.addModifyListener(this.modifyListener);
        this.yoffText.addModifyListener(this.modifyListener);
        this.zoffText.addModifyListener(this.modifyListener);
        String errMsg = null;
        if (errMsg == null && this.file == null) {
            errMsg = "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        }
        if (errMsg == null && scaleStr.length() == 0) {
            errMsg = "\u30b9\u30b1\u30fc\u30eb\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        }
        if (errMsg == null && scale <= 0.0) {
            errMsg = "\u30b9\u30b1\u30fc\u30eb\u306b\u306f0\u3088\u308a\u5927\u304d\u3044\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        }
        if (this.originCombo.getSelectionIndex() == 2) {
            String xStr = this.xoffText.getText().trim();
            String yStr = this.yoffText.getText().trim();
            String zStr = this.zoffText.getText().trim();
            double x = Double.NaN;
            double y = Double.NaN;
            double z = Double.NaN;
            try {
                x = Double.parseDouble(xStr);
                y = Double.parseDouble(yStr);
                z = Double.parseDouble(zStr);
            }
            catch (NumberFormatException numberFormatException) {}
            if (errMsg == null && (xStr.length() == 0 || yStr.length() == 0 || zStr.length() == 0)) {
                errMsg = "\u4f4d\u7f6e\u306e\u57fa\u6e96\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            if (errMsg == null && (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z))) {
                errMsg = "\u4f4d\u7f6e\u306e\u57fa\u6e96\u306b\u306f\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
        }
        this.setErrorMessage(errMsg);
        this.setPageComplete(errMsg == null);
    }

    void saveDefaults() {
    }

    File getFile() {
        if (this.isPageComplete()) {
            return this.file;
        }
        throw new IllegalStateException();
    }

    double getScale() {
        if (this.isPageComplete()) {
            return Double.parseDouble(this.scaleText.getText().trim()) * 0.01;
        }
        throw new IllegalStateException();
    }

    Vec3d getOffset() {
        if (this.isPageComplete()) {
            double x = Double.parseDouble(this.xoffText.getText().trim());
            double y = Double.parseDouble(this.yoffText.getText().trim());
            double z = Double.parseDouble(this.zoffText.getText().trim());
            return new Vec3d(x, y, z);
        }
        throw new IllegalStateException();
    }

    Javie2MMDOutput.ViewingAngleRounding getViewingAngleRounding() {
        if (this.isPageComplete()) {
            return Javie2MMDOutput.ViewingAngleRounding.values()[this.roundingCombo.getSelectionIndex()];
        }
        throw new IllegalStateException();
    }
}

