/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.app.wizards.AVIOutputSettingsWizardPage;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.output.WindowsDirectShowOutput;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AVIOutputWizard
extends Wizard {
    private final AVIOutputSettingsWizardPage page;
    private final WindowsDirectShowOutput output;

    public AVIOutputWizard(Composition composition, WindowsDirectShowOutput output) {
        this.page = new AVIOutputSettingsWizardPage(composition, output.getFile());
        this.output = output;
        this.setWindowTitle("\u66f8\u304d\u51fa\u3057 - AVI");
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveDefaults();
        this.output.setFile(this.page.getFile());
        this.output.setBatch(this.page.isBatch());
        boolean videoEnabled = this.page.isVideoEnabled();
        this.output.setVideoEnabled(videoEnabled);
        if (videoEnabled) {
            this.output.setVideoChannels(this.page.getVideoChannels());
            this.output.setColorMatte(this.page.getColorMatte());
            this.output.setVideoCompressorSettings(this.page.getVideoCompressorSettings());
        }
        boolean audioEnabled = this.page.isAudioEnabled();
        this.output.setAudioEnabled(audioEnabled);
        if (audioEnabled) {
            this.output.setAudioMode(this.page.getAudioMode());
        }
        return true;
    }
}

