/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.views.layercomp.AngleElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.app.views.layercomp.ScaleElementDelegate;
import ch.kuramo.javie.app.views.layercomp.Tiny2DManipVec3dElementDelegate;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.Util;
import java.util.List;

public class TransformElement
extends Element {
    private final List<LayerAnimatableValueElement> children = Util.newList();
    private boolean threeD;

    public TransformElement(LayerElement parent) {
        super(parent);
    }

    private TransformableLayer getLayer() {
        return (TransformableLayer)((LayerElement)this.parent).layer;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30e0";
            }
        }
        return null;
    }

    public boolean hasChildren() {
        return true;
    }

    public Element[] getChildren() {
        TransformableLayer layer = this.getLayer();
        boolean currentThreeD = LayerNature.isThreeD((Layer)layer);
        if (this.threeD == currentThreeD && this.children.size() > 0) {
            return this.children.toArray(new Element[this.children.size()]);
        }
        this.children.clear();
        this.threeD = currentThreeD;
        if (currentThreeD) {
            this.createChildElement("anchorPoint", "\u30a2\u30f3\u30ab\u30fc\u30dd\u30a4\u30f3\u30c8");
            this.createChildElement("position", "\u4f4d\u7f6e");
            this.createScaleElement("scale", "\u30b9\u30b1\u30fc\u30eb", "%");
            this.createChildElement("orientation", "\u65b9\u5411", "\u00b0");
            this.createAngleElement("rotationX", "X \u56de\u8ee2", "\u00b0");
            this.createAngleElement("rotationY", "Y \u56de\u8ee2", "\u00b0");
            this.createAngleElement("rotationZ", "Z \u56de\u8ee2", "\u00b0");
            if (layer instanceof MediaLayer) {
                this.createChildElement("opacity", "\u4e0d\u900f\u660e\u5ea6", "%");
            }
        } else {
            this.createTiny2DManipVec3dElement("anchorPoint", "\u30a2\u30f3\u30ab\u30fc\u30dd\u30a4\u30f3\u30c8");
            this.createTiny2DManipVec3dElement("position", "\u4f4d\u7f6e");
            this.createScaleElement("scale", "\u30b9\u30b1\u30fc\u30eb", "%");
            this.createAngleElement("rotationZ", "\u56de\u8ee2", "\u00b0");
            if (layer instanceof MediaLayer) {
                this.createChildElement("opacity", "\u4e0d\u900f\u660e\u5ea6", "%");
            }
        }
        return this.children.toArray(new Element[this.children.size()]);
    }

    private void createChildElement(String property, String name) {
        this.children.add(LayerAnimatableValueElement.forSimpleProperty(this, (Layer)this.getLayer(), property, name, null));
    }

    private void createChildElement(String property, String name, String unit) {
        this.children.add(LayerAnimatableValueElement.forSimpleProperty(this, (Layer)this.getLayer(), property, name, unit));
    }

    private void createTiny2DManipVec3dElement(String property, String name) {
        this.children.add(new LayerAnimatableValueElement.ForSimpleProperty(this, (Layer)this.getLayer(), property, name){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableVec3d avalue = (AnimatableVec3d)PropertyUtil.getProperty(this.layer, this.getProperty());
                return new Tiny2DManipVec3dElementDelegate((AnimatableValueElement)this, this.name, avalue);
            }
        });
    }

    private void createScaleElement(String property, String name, String unit) {
        this.children.add(new LayerAnimatableValueElement.ForSimpleProperty(this, (Layer)this.getLayer(), property, name, unit){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableVec3d avalue = (AnimatableVec3d)PropertyUtil.getProperty(this.layer, this.getProperty());
                boolean threeD = LayerNature.isThreeD((Layer)this.layer);
                return new ScaleElementDelegate(this, this.name, avalue, threeD, this.unit);
            }
        });
    }

    private void createAngleElement(String property, String name, String unit) {
        this.children.add(new LayerAnimatableValueElement.ForSimpleProperty(this, (Layer)this.getLayer(), property, name, unit){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableDouble avalue = (AnimatableDouble)PropertyUtil.getProperty(this.layer, this.getProperty());
                return new AngleElementDelegate(this, this.name, avalue, this.unit);
            }
        });
    }
}

