/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.project.NewTextAnimatorOperation;
import ch.kuramo.javie.app.project.PerCharacter3DOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.TAOptionsElement;
import ch.kuramo.javie.app.views.layercomp.TextAnimatorElement;
import ch.kuramo.javie.app.views.layercomp.TextElement;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.TAProperty;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;

public class TextAnimatorsElement
extends Element {
    private static final int[] UNDERLINE_DASH = new int[]{2, 2};
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final boolean WIN32 = SWT.getPlatform().equals("win32");
    private Rectangle valueArea;
    private final List<Element> children = Util.newList();
    private TAOptionsElement optionsElement;
    private final Map<TextAnimator, TextAnimatorElement> animatorElementMap = Util.newMap();

    public TextAnimatorsElement(TextElement parent) {
        super(parent);
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf";
            }
            case 1: {
                return " ";
            }
        }
        return null;
    }

    public void paintColumn(Event event) {
        if (event.index == 1) {
            String valueStr = ">";
            GC gc = event.gc;
            int x = event.x + 5;
            int y = event.y;
            int height = ((TreeItem)event.item).getBounds((int)event.index).height;
            boolean focused = (event.detail & 2) != 0 && ((Control)event.widget).isFocusControl();
            gc.setForeground(gc.getDevice().getSystemColor(focused ? 1 : 10));
            Point extent = gc.textExtent(valueStr, 1);
            gc.drawString(valueStr, x, y += (height - extent.y) / 2, true);
            this.valueArea = new Rectangle(x, y, extent.x, extent.y);
            y += extent.y;
            gc.setLineDash(UNDERLINE_DASH);
            if (COCOA) {
                gc.drawLine(x, y - 1, x + extent.x, y - 1);
            } else if (WIN32) {
                gc.drawLine(x, y, x + extent.x - 2, y);
            } else {
                gc.drawLine(x, y, x + extent.x, y);
            }
        } else {
            super.paintColumn(event);
        }
    }

    public void updateCursor(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                Cursor cursor = null;
                if (this.valueArea != null && this.valueArea.contains(event.x, event.y)) {
                    cursor = event.display.getSystemCursor(21);
                }
                this.viewer.getTree().setCursor(cursor);
                break;
            }
            default: {
                super.updateCursor(event, columnIndex);
            }
        }
    }

    public void mouseDown(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                if (event.button != 1 || this.valueArea == null || !this.valueArea.contains(event.x, event.y)) break;
                this.showMenu();
                break;
            }
            default: {
                super.mouseDown(event, columnIndex);
            }
        }
    }

    private void showMenu() {
        Menu menu = this.createPopUpMenu(this.valueArea.x - 5, this.valueArea.y);
        final TextLayer layer = this.getLayer();
        boolean perCharacter3D = LayerNature.isThreeD((Layer)layer) && layer.isPerCharacter3D();
        Action action = new Action("\u6587\u5b57\u5358\u4f4d\u306e3D\u5316", 2){

            public void run() {
                ProjectManager pm = (ProjectManager)TextAnimatorsElement.this.viewer.getData("PROJECT_MANAGER");
                pm.postOperation(PerCharacter3DOperation.toggle(pm, layer));
            }
        };
        action.setChecked(perCharacter3D);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
        new MenuItem(menu, 2);
        Map propActions = Util.newMap();
        TAProperty[] tAPropertyArray = TAProperty.values();
        int n = tAPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                TAProperty[] properties;
                TAProperty p = tAPropertyArray[n2];
                switch (p) {
                    case skewAxis: 
                    case rotationX: 
                    case rotationY: 
                    case characterRange: {
                        break block8;
                    }
                    case rotationZ: {
                        if (perCharacter3D) {
                            properties = new TAProperty[]{TAProperty.rotationX, TAProperty.rotationY, TAProperty.rotationZ};
                            break;
                        }
                        properties = new TAProperty[]{TAProperty.rotationZ};
                        break;
                    }
                    case skew: {
                        properties = new TAProperty[]{TAProperty.skew, TAProperty.skewAxis};
                        break;
                    }
                    case characterValue: 
                    case characterOffset: {
                        properties = new TAProperty[]{TAProperty.characterRange, p};
                        break;
                    }
                    default: {
                        properties = new TAProperty[]{p};
                    }
                }
                action = new Action(EnumLabels.getLabel(p)){

                    public void run() {
                        ProjectManager pm = (ProjectManager)TextAnimatorsElement.this.viewer.getData("PROJECT_MANAGER");
                        pm.postOperation(new NewTextAnimatorOperation(pm, layer, properties));
                    }
                };
                propActions.put(p, action);
            }
            ++n2;
        }
        TextAnimatorElement.createPropertyMenuItems(menu, propActions);
        menu.setVisible(true);
    }

    public boolean hasChildren() {
        return !this.getLayer().getTextAnimators().isEmpty();
    }

    public Element[] getChildren() {
        this.prepareChildren();
        return this.children.toArray(new Element[this.children.size()]);
    }

    TextLayer getLayer() {
        return ((TextElement)this.parent).getLayer();
    }

    private TextAnimatorElement getTextAnimatorElement(TextAnimator animator) {
        TextAnimatorElement element = this.animatorElementMap.get(animator);
        if (element == null) {
            element = new TextAnimatorElement(this, animator);
            this.animatorElementMap.put(animator, element);
        }
        return element;
    }

    private void prepareChildren() {
        this.children.clear();
        TextLayer layer = this.getLayer();
        if (this.optionsElement == null) {
            this.optionsElement = new TAOptionsElement(this);
        }
        this.children.add(this.optionsElement);
        for (TextAnimator animator : layer.getTextAnimators()) {
            this.children.add(this.getTextAnimatorElement(animator));
        }
        this.animatorElementMap.values().retainAll(this.children);
    }
}

