/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ModifyLayerPropertyOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.RenameTASelectorOperation;
import ch.kuramo.javie.app.views.layercomp.AngleElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerEnumPropertyElement;
import ch.kuramo.javie.app.views.layercomp.Switch;
import ch.kuramo.javie.app.views.layercomp.SwitchGroup;
import ch.kuramo.javie.app.views.layercomp.TextAnimatorElement;
import ch.kuramo.javie.app.widgets.WSWin32;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TASelectorElement<T extends TASelector>
extends Element {
    public final T selector;
    private final SwitchGroup enableSwitch = new SwitchGroup();
    private TextCellEditor nameEditor;
    private static final ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();

    public TASelectorElement(TextAnimatorElement parent, T selector) {
        super(parent);
        this.selector = selector;
        this.enableSwitch.add(new EnableSwitch());
        if (WSWin32.isXPThemed()) {
            this.enableSwitch.setMarginLeft(11);
        }
    }

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.selector.getName();
            }
        }
        return null;
    }

    @Override
    public void paintColumn(Event event) {
        switch (event.index) {
            case 5: {
                this.enableSwitch.paint(event);
                break;
            }
            default: {
                super.paintColumn(event);
            }
        }
    }

    @Override
    public void mouseDown(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 5: {
                this.enableSwitch.mouseDown(event);
                break;
            }
            default: {
                super.mouseDown(event, columnIndex);
            }
        }
    }

    @Override
    public boolean canEdit(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.TRUE.equals(this.viewer.getData("EDIT_ELEMENT_NAME"));
            }
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.nameEditor == null) {
                    this.nameEditor = new TextCellEditor((Composite)this.viewer.getTree(), 2052);
                    Control control = this.nameEditor.getControl();
                    control.setBackground(control.getDisplay().getSystemColor(1));
                }
                return this.nameEditor;
            }
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.selector.getName();
            }
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        ProjectManager pm = (ProjectManager)this.viewer.getData("PROJECT_MANAGER");
        switch (columnIndex) {
            case 0: {
                String newName = (String)value;
                if (newName.length() <= 0) break;
                pm.postOperation(new RenameTASelectorOperation(pm, this.getLayer(), this.getTextAnimator(), (TASelector)this.selector, newName));
            }
        }
    }

    protected TextLayer getLayer() {
        return ((TextAnimatorElement)this.parent).getLayer();
    }

    protected TextAnimator getTextAnimator() {
        return ((TextAnimatorElement)this.parent).animator;
    }

    private String getCombinedProperty(String property) {
        TextAnimator animator = this.getTextAnimator();
        int animatorIndex = this.getLayer().getTextAnimators().indexOf(animator);
        int selectorIndex = animator.getSelectors().indexOf(this.selector);
        return String.format("textAnimators[%d].selectors[%d].%s", animatorIndex, selectorIndex, property);
    }

    protected LayerAnimatableValueElement createPropertyElement(String property, String name, String unit) {
        return new TASelectorAnimatableValueElement(property, name, unit);
    }

    protected LayerAnimatableValueElement createPropertyElement(String property, String name) {
        return this.createPropertyElement(property, name, null);
    }

    protected LayerAnimatableValueElement createAngleElement(String property, String name, String unit) {
        return new TASelectorAnimatableValueElement(property, name, unit){

            @Override
            protected AnimatableValueElementDelegate<?> createDelegate() {
                AnimatableDouble avalue = (AnimatableDouble)PropertyUtil.getProperty(this.layer, this.getProperty());
                return new AngleElementDelegate(this, this.name, avalue, this.unit);
            }
        };
    }

    protected LayerEnumPropertyElement<?> createEnumPropertyElement(final String property, String name) {
        LayerEnumPropertyElement element = new LayerEnumPropertyElement(this, (Layer)this.getLayer(), name){

            public String getProperty() {
                return TASelectorElement.this.getCombinedProperty(property);
            }
        };
        return element;
    }

    private class EnableSwitch
    implements Switch {
        private EnableSwitch() {
        }

        public boolean hasBorder() {
            return true;
        }

        public Image getImage() {
            return TASelectorElement.this.selector.isEnabled() ? imageRegistry.get("IMG_SWITCH_VIDEO") : null;
        }

        public void mouseDown(MouseEvent event) {
            boolean currentEnabled = TASelectorElement.this.selector.isEnabled();
            String label = currentEnabled ? "\u30bb\u30ec\u30af\u30bf\u3092\u7121\u52b9\u306b\u3059\u308b" : "\u30bb\u30ec\u30af\u30bf\u3092\u6709\u52b9\u306b\u3059\u308b";
            ProjectManager pm = (ProjectManager)TASelectorElement.this.viewer.getData("PROJECT_MANAGER");
            TextLayer layer = TASelectorElement.this.getLayer();
            TextAnimator animator = TASelectorElement.this.getTextAnimator();
            int animatorIndex = layer.getTextAnimators().indexOf(animator);
            int selectorIndex = animator.getSelectors().indexOf(TASelectorElement.this.selector);
            String property = String.format("textAnimators[%d].selectors[%d].enabled", animatorIndex, selectorIndex);
            pm.postOperation(new ModifyLayerPropertyOperation<Boolean>(pm, (Layer)layer, property, !currentEnabled, label));
        }
    }

    private class TASelectorAnimatableValueElement
    extends LayerAnimatableValueElement {
        private final String property;

        public TASelectorAnimatableValueElement(String property, String name, String unit) {
            super(TASelectorElement.this, (Layer)TASelectorElement.this.getLayer(), name, unit);
            this.property = property;
        }

        protected String getDefaultExpression() {
            return String.format("textAnimator(\"%s\").selector(\"%s\").%s", TASelectorElement.this.getTextAnimator().getName().replaceAll("\"", "\\\\\""), TASelectorElement.this.selector.getName().replaceAll("\"", "\\\\\""), this.property);
        }

        public String getProperty() {
            return TASelectorElement.this.getCombinedProperty(this.property);
        }
    }
}

