/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.project.LayerSwitchOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.layercomp.LayerSwitch;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.MotionBlur;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;

class MotionBlurSwitch
extends LayerSwitch {
    public MotionBlurSwitch(ProjectManager projectManager, Layer layer) {
        super(projectManager, layer);
    }

    public Image getImage() {
        MotionBlur mblur = LayerNature.getMotionBlur((Layer)this.layer);
        if (LayerNature.isCTCR((Layer)this.layer) && ((MediaLayer)this.layer).isVectorLayer() && mblur == MotionBlur.TRANSFORM) {
            mblur = MotionBlur.FULL;
        }
        switch (mblur) {
            case TRANSFORM: {
                return this.getImage("IMG_SWITCH_MBLUR_TRANSFORM");
            }
            case FULL: {
                return this.getImage("IMG_SWITCH_MBLUR_FULL");
            }
        }
        return null;
    }

    public void mouseDown(MouseEvent event) {
        MotionBlur newValue;
        MotionBlur oldValue = LayerNature.getMotionBlur((Layer)this.layer);
        if (LayerNature.isCTCR((Layer)this.layer) && ((MediaLayer)this.layer).isVectorLayer()) {
            newValue = oldValue != MotionBlur.NONE ? MotionBlur.NONE : MotionBlur.FULL;
        } else {
            MotionBlur[] values = MotionBlur.values();
            newValue = values[(oldValue.ordinal() + 1) % values.length];
        }
        this.projectManager.postOperation(new LayerSwitchOperation.MotionBlur(this.projectManager, this.layer, newValue));
    }
}

