/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.project.LayerCompSuperSamplingOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.SuperSampling;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class LayerCompSuperSamplingAction
extends Action
implements IMenuCreator {
    private final ProjectManager pm;
    private final LayerComposition comp;
    private Menu menu;

    public LayerCompSuperSamplingAction(final LayerCompositionView view) {
        super("\u30b9\u30fc\u30d1\u30fc\u30b5\u30f3\u30d7\u30ea\u30f3\u30b0");
        this.pm = ProjectManager.forWorkbenchWindow(view.getSite().getWorkbenchWindow());
        this.comp = view.getLayerComposition();
        this.setImageDescriptor(ImageUtil.getCompositionSuperSamplingIcon(this.comp.getSuperSampling()));
        this.setMenuCreator(this);
        final IOperationHistoryListener historyListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                switch (event.getEventType()) {
                    case 4: 
                    case 9: 
                    case 10: {
                        IUndoableOperation op = event.getOperation();
                        if (!(op instanceof LayerCompSuperSamplingOperation) || !op.hasContext(LayerCompSuperSamplingAction.this.pm.getUndoContext())) break;
                        LayerCompSuperSamplingAction.this.setImageDescriptor(ImageUtil.getCompositionSuperSamplingIcon(LayerCompSuperSamplingAction.this.comp.getSuperSampling()));
                    }
                }
            }
        };
        view.getSite().getPage().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == view) {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().removeOperationHistoryListener(historyListener);
                }
            }
        });
        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().addOperationHistoryListener(historyListener);
    }

    public void dispose() {
        this.disposeMenu();
    }

    private void disposeMenu() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        this.disposeMenu();
        if (!this.isEnabled()) {
            return null;
        }
        this.menu = new Menu(parent);
        SuperSampling[] superSamplingArray = SuperSampling.values();
        int n = superSamplingArray.length;
        int n2 = 0;
        while (n2 < n) {
            SuperSampling ss = superSamplingArray[n2];
            this.addAction(this.menu, ss);
            ++n2;
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void addAction(Menu parent, final SuperSampling ss) {
        String text;
        switch (ss) {
            case SS_NONE: {
                text = "\u30b9\u30fc\u30d1\u30fc\u30b5\u30f3\u30d7\u30ea\u30f3\u30b0\uff1a\u306a\u3057";
                break;
            }
            default: {
                text = ss.name().substring(3).toLowerCase();
            }
        }
        Action action = new Action(text, 8){

            public void run() {
                LayerCompSuperSamplingAction.this.pm.postOperation(new LayerCompSuperSamplingOperation(LayerCompSuperSamplingAction.this.pm, LayerCompSuperSamplingAction.this.comp, ss));
            }
        };
        action.setChecked(ss == this.comp.getSuperSampling());
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }
}

