/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceLayerItemOperation<T extends Item>
extends ProjectOperation {
    private final String compId;
    private final String layerId;
    private final String oldItemId;
    private final String newItemId;

    public ReplaceLayerItemOperation(ProjectManager pm, ItemLayer<T> layer, T newItem) {
        super(pm, "\u30bd\u30fc\u30b9\u306e\u7f6e\u304d\u63db\u3048");
        LayerComposition comp = pm.checkLayer((Layer)layer);
        pm.checkItem((Item)newItem);
        if (newItem instanceof CompositionItem && ReplaceLayerItemOperation.checkCyclicComposition(comp, (CompositionItem)newItem)) {
            throw new IllegalArgumentException("cyclic composition");
        }
        this.compId = comp.getId();
        this.layerId = layer.getId();
        this.oldItemId = layer.getItem().getId();
        this.newItemId = newItem.getId();
        this._noEffect = this.newItemId.equals(this.oldItemId);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setMediaItem(project, pm, this.newItemId);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setMediaItem(project, pm, this.oldItemId);
        return Status.OK_STATUS;
    }

    private void setMediaItem(Project project, ProjectManager pm, String itemId) {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        ItemLayer layer = (ItemLayer)comp.getLayer(this.layerId);
        Item item = project.getItem(itemId);
        layer.setItem(item);
        if (pm != null) {
            pm.fireLayerItemChange(layer);
        }
    }

    public static boolean checkCyclicComposition(LayerComposition comp, CompositionItem compItem) {
        Composition otherComp = compItem.getComposition();
        if (otherComp == comp) {
            return true;
        }
        if (otherComp instanceof LayerComposition) {
            for (Layer layer : ((LayerComposition)otherComp).getLayers()) {
                Item item;
                if (!(layer instanceof ItemLayer) || !((item = ((ItemLayer)layer).getItem()) instanceof CompositionItem) || !ReplaceLayerItemOperation.checkCyclicComposition(comp, (CompositionItem)item)) continue;
                return true;
            }
        }
        return false;
    }
}

