/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RenameTextAnimatorOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final int _animatorIndex;
    private final String _oldName;
    private final String _newName;

    public RenameTextAnimatorOperation(ProjectManager pm, TextLayer layer, TextAnimator animator, String newName) {
        super(pm, "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf\u306e\u540d\u524d\u3092\u5909\u66f4");
        LayerComposition comp = pm.checkLayer((Layer)layer);
        int index = layer.getTextAnimators().indexOf(animator);
        if (index == -1) {
            throw new IllegalArgumentException("no such TextAnimator found in the layer");
        }
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._animatorIndex = index;
        this._oldName = animator.getName();
        this._newName = newName;
        this._noEffect = newName.equals(this._oldName);
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setAnimatorName(this._newName, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setAnimatorName(this._oldName, project, pm);
        return Status.OK_STATUS;
    }

    private void setAnimatorName(String name, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        TextLayer layer = (TextLayer)comp.getLayer(this._layerId);
        TextAnimator animator = (TextAnimator)layer.getTextAnimators().get(this._animatorIndex);
        animator.setName(name);
        if (pm != null) {
            pm.fireLayerPropertyChange((Layer)layer, String.format("textAnimators[%d].name", this._animatorIndex));
        }
    }
}

