/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.List;
import java.util.SortedMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyLayerKeyframesOperation<V>
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _property;
    private final List<Keyframe<V>> _oldKeyframes = Util.newList();
    private final List<Keyframe<V>> _newKeyframes = Util.newList();

    public ModifyLayerKeyframesOperation(ProjectManager projectManager, Layer layer, String property, Time[] times, V[] values, String label) {
        super(projectManager, label);
        if (times.length != values.length) {
            throw new IllegalArgumentException();
        }
        LayerComposition comp = projectManager.checkLayer(layer);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._property = property;
        int i = 0;
        while (i < times.length) {
            Time t = times[i];
            V v = values[i];
            Keyframe oldKf = avalue.getKeyframe(t);
            Keyframe newKf = new Keyframe(t, v, this.defaultInterpolation(avalue, oldKf, t));
            this._oldKeyframes.add(oldKf);
            this._newKeyframes.add(newKf);
            ++i;
        }
    }

    private Interpolation defaultInterpolation(AnimatableValue<V> avalue, Keyframe<V> oldKeyframe, Time time) {
        if (oldKeyframe != null) {
            return oldKeyframe.interpolation;
        }
        SortedMap head = avalue.getKeyframeMap().headMap(time);
        if (!head.isEmpty()) {
            return ((Keyframe)head.get((Object)head.lastKey())).interpolation;
        }
        return avalue.getDefaultInterpolation();
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.replaceKeyframe(false, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.replaceKeyframe(true, project, pm);
        return Status.OK_STATUS;
    }

    private void replaceKeyframe(boolean undo, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, this._property);
        Object[][] data = new Object[this._oldKeyframes.size()][];
        int i = 0;
        int n = this._oldKeyframes.size();
        while (i < n) {
            Keyframe<V> replacement;
            Keyframe<V> target = undo ? this._newKeyframes.get(i) : this._oldKeyframes.get(i);
            Keyframe<V> keyframe = replacement = undo ? this._oldKeyframes.get(i) : this._newKeyframes.get(i);
            if (replacement != null) {
                avalue.putKeyframe(replacement);
                data[i] = new Object[]{layer, -1, this._property, replacement.time};
            } else {
                avalue.removeKeyframe(target.time);
                data[i] = new Object[]{layer, -1, this._property, target.time};
            }
            ++i;
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, data);
        }
    }
}

