/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateTextAnimatorsOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Object[]> _srcData;
    private final String _dstLayerId;
    private final int _dstIndex;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public DuplicateTextAnimatorsOperation(ProjectManager pm, List<Object[]> animators, TextLayer dstLayer, int insertBefore) {
        super(pm, "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf\u306e\u8907\u88fd");
        InjectorHolder.getInjector().injectMembers((Object)this);
        if (animators.isEmpty()) {
            this._noEffect = true;
            this._compId = null;
            this._srcData = null;
            this._dstLayerId = null;
            this._dstIndex = 0;
            return;
        }
        LayerComposition comp = pm.checkLayer((Layer)((TextLayer)animators.get(0)[0]));
        if (dstLayer != null && pm.checkLayer((Layer)dstLayer) != comp) {
            throw new IllegalArgumentException();
        }
        this._compId = comp.getId();
        this._srcData = Util.newList();
        if (dstLayer != null) {
            this._dstLayerId = dstLayer.getId();
            int dstAnimatorCount = dstLayer.getTextAnimators().size();
            this._dstIndex = insertBefore < 0 || insertBefore > dstAnimatorCount ? dstAnimatorCount : insertBefore;
        } else {
            this._dstLayerId = null;
            this._dstIndex = 0;
        }
        for (Object[] o : animators) {
            TextLayer srcLayer = (TextLayer)o[0];
            TextAnimator animator = (TextAnimator)o[1];
            int layerIndex = comp.getLayers().indexOf(srcLayer);
            if (layerIndex == -1) {
                throw new IllegalArgumentException();
            }
            int animatorIndex = srcLayer.getTextAnimators().indexOf(animator);
            if (animatorIndex == -1) {
                throw new IllegalArgumentException();
            }
            this._srcData.add(new Object[]{layerIndex, animatorIndex, this._encoder.encodeElement((Object)animator)});
        }
        Collections.sort(this._srcData, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                int compare = (Integer)o1[0] - (Integer)o2[0];
                return compare != 0 ? compare : (Integer)o2[1] - (Integer)o1[1];
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        block11: {
            comp = (LayerComposition)project.getComposition(this._compId);
            data = null;
            if (pm != null) {
                data = Util.newList();
            }
            newAnimators = Util.newSet();
            try {
                if (this._dstLayerId != null) {
                    dstLayer = (TextLayer)comp.getLayer(this._dstLayerId);
                    for (Object[] o : this._srcData) {
                        animator = (TextAnimator)this._decoder.decodeElement((CharSequence)((String)o[2]), TextAnimator.class);
                        dstLayer.getTextAnimators().add(this._dstIndex, animator);
                        newAnimators.add(animator);
                        if (pm == null) continue;
                        data.add(new Object[]{dstLayer, this._dstIndex + data.size()});
                    }
                } else {
                    for (Object[] o : this._srcData) {
                        animator = (TextAnimator)this._decoder.decodeElement((CharSequence)((String)o[2]), TextAnimator.class);
                        srcLayer = (TextLayer)comp.getLayers().get((Integer)o[0]);
                        srcLayer.getTextAnimators().add((Integer)o[1] + 1, animator);
                        newAnimators.add(animator);
                        if (pm == null) continue;
                        data.add(new Object[]{srcLayer, animator});
                    }
                    if (pm != null) {
                        for (Object[] o : data) {
                            o[1] = ((TextLayer)o[0]).getTextAnimators().indexOf(o[1]);
                        }
                    }
                }
                break block11;
            }
            catch (ProjectDecodeException e) {
                ** for (layer : comp.getLayers())
            }
lbl-1000:
            // 1 sources

            {
                if (!(layer instanceof TextLayer)) continue;
                ((TextLayer)layer).getTextAnimators().removeAll(newAnimators);
                continue;
            }
lbl40:
            // 1 sources

            throw new ExecutionException("error decoding TextAnimator data", (Throwable)e);
        }
        if (pm != null) {
            pm.fireTextAnimatorsAdd(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        if (this._dstLayerId != null) {
            TextLayer dstLayer = (TextLayer)comp.getLayer(this._dstLayerId);
            dstLayer.getTextAnimators().subList(this._dstIndex, this._dstIndex + this._srcData.size()).clear();
            if (pm != null) {
                pm.fireTextAnimatorsRemove(comp, new Object[][]{{dstLayer, -1}});
            }
        } else {
            List data = null;
            if (pm != null) {
                data = Util.newList();
            }
            ListIterator<Object[]> it = this._srcData.listIterator(this._srcData.size());
            while (it.hasPrevious()) {
                Object[] o = it.previous();
                TextLayer srcLayer = (TextLayer)comp.getLayers().get((Integer)o[0]);
                srcLayer.getTextAnimators().remove((Integer)o[1] + 1);
                if (pm == null) continue;
                data.add(new Object[]{srcLayer, -1});
            }
            if (pm != null) {
                pm.fireTextAnimatorsRemove(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
            }
        }
        return Status.OK_STATUS;
    }
}

