/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.ApplicationWorkbenchWindowAdvisor;
import ch.kuramo.javie.app.Initializer;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.Perspective;
import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.SplashProgressMonitor;
import ch.kuramo.javie.app.player.GLCanvasFactory;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.GLGlobal;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.LinearUndoEnforcer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationWorkbenchAdvisor.class);

    private void createDefaultConsole() {
        MessageConsole console = new MessageConsole("\u30b3\u30f3\u30bd\u30fc\u30eb", null);
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.addConsoles(new IConsole[]{console});
        IOConsoleOutputStream out = console.newOutputStream();
        IOConsoleOutputStream err = console.newOutputStream();
        System.setOut(new PrintStream((OutputStream)out));
        System.setErr(new PrintStream((OutputStream)err));
        Display display = Display.getDefault();
        err.setColor(display.getSystemColor(3));
    }

    private boolean checkHeapAndModifyJavieIni() {
        long physMemSize;
        long curMaxHeap;
        Version iniVers;
        Version curVers;
        block9: {
            String vmargs = System.getProperty("eclipse.vmargs");
            if (vmargs == null) {
                return false;
            }
            curVers = Platform.getProduct().getDefiningBundle().getVersion();
            iniVers = Version.parseVersion((String)System.getProperty("javie.ini.version"));
            String[] stringArray = vmargs.split("\n|\r\n?");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.startsWith("-Xmx")) {
                    logger.info("-Xmx found in vmargs: " + arg);
                    if (iniVers.compareTo((Object)new Version(0, 5, 1)) < 0) {
                        return this.updateJavieIni(0L, curVers.toString(), iniVers.toString());
                    }
                    return false;
                }
                ++n2;
            }
            MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapUsage = mbean.getHeapMemoryUsage();
            curMaxHeap = heapUsage.getMax();
            logger.info("Max Heap Size: " + curMaxHeap);
            try {
                OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
                Class<?> clazz = Class.forName("com.sun.management.OperatingSystemMXBean");
                if (clazz.isInstance(osMXBean)) {
                    Method m = clazz.getMethod("getTotalPhysicalMemorySize", new Class[0]);
                    physMemSize = (Long)m.invoke((Object)osMXBean, new Object[0]);
                    logger.info("Physical Memory Size: " + physMemSize);
                    break block9;
                }
                logger.warn("cannot get physical memory size: OperatingSystemMXBean is not instance of com.sun.management.OperatingSystemMXBean");
                return false;
            }
            catch (Exception e) {
                logger.warn("error getting physical memory size", (Throwable)e);
                return false;
            }
        }
        if (physMemSize < 256000000L) {
            logger.warn("physical memory size is too little.");
            return false;
        }
        long newMaxHeap = physMemSize < 512000000L ? physMemSize * 3L / 4L - 128000000L : Math.min(physMemSize / 2L, 512000000L);
        if (newMaxHeap <= curMaxHeap) {
            return false;
        }
        return this.updateJavieIni(newMaxHeap, curVers.toString(), iniVers.toString());
    }

    private boolean updateJavieIni(long newMaxHeap, String newIniVers, String oldIniVers) {
        String newXmx;
        newIniVers = "-Djavie.ini.version=" + newIniVers;
        logger.info("Adding to vmargs: " + newIniVers);
        if (newMaxHeap > 0L) {
            newXmx = "-Xmx" + newMaxHeap;
            logger.info("Adding to vmargs: " + newXmx);
        } else {
            newXmx = null;
        }
        try {
            File curIniFile = new File("Javie.ini");
            File newIniFile = new File("Javie.ini.new");
            BufferedReader br = null;
            PrintWriter pr = null;
            try {
                String line;
                boolean added = false;
                br = new BufferedReader(new FileReader(curIniFile));
                pr = new PrintWriter(newIniFile);
                while ((line = br.readLine()) != null) {
                    String trim = line.trim();
                    if (trim.startsWith("-Xmx") || trim.startsWith("-Djavie.ini.version=")) continue;
                    pr.println(line);
                    if (!trim.equals("-vmargs")) continue;
                    pr.println(newIniVers);
                    if (newXmx != null) {
                        pr.println(newXmx);
                    }
                    added = true;
                }
                if (!added) {
                    pr.println("-vmargs");
                    pr.println(newIniVers);
                    if (newXmx != null) {
                        pr.println(newXmx);
                    }
                }
            }
            finally {
                if (pr != null) {
                    pr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            if (curIniFile.renameTo(new File("Javie.ini." + oldIniVers))) {
                logger.error("cannot rename Javie.ini to Javie.ini." + oldIniVers);
            }
            if (!newIniFile.renameTo(curIniFile)) {
                logger.error("cannot rename Javie.ini.new to Javie.ini");
                return false;
            }
        }
        catch (IOException e) {
            logger.error("error modifing Javie.ini", (Throwable)e);
            return false;
        }
        return true;
    }

    public void initialize(final IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        SplashProgressMonitor.beginTask("", 8);
        SplashProgressMonitor.subTask("Creating Default Console");
        this.createDefaultConsole();
        SplashProgressMonitor.worked(1);
        SplashProgressMonitor.subTask("Checking Heap Size");
        if (this.checkHeapAndModifyJavieIni()) {
            configurer.getWorkbench().restart();
            return;
        }
        SplashProgressMonitor.worked(1);
        SplashProgressMonitor.subTask("");
        configurer.setSaveAndRestore(true);
        IOperationHistory history = configurer.getWorkbench().getOperationSupport().getOperationHistory();
        history.addOperationApprover((IOperationApprover)new LinearUndoEnforcer());
        SplashProgressMonitor.worked(1);
        SplashProgressMonitor.subTask("Initializing OpenGL");
        String os = Platform.getOS();
        boolean win32 = os.equals("win32");
        boolean macosx = os.equals("macosx");
        final GLGlobal glGlobal = (GLGlobal)InjectorHolder.getInjector().getInstance(GLGlobal.class);
        if (glGlobal.getInitError() == null) {
            logger.info("\n\n***** OpenGL Report *****\nVendor: " + (glGlobal.isIntel() ? "Intel" : (glGlobal.isAmdAti() ? "AMD" : (glGlobal.isNvidia() ? "NVIDIA" : "Unknown"))) + "\n" + "Driver Version: " + glGlobal.getDriverVersion() + "\n\n" + glGlobal.getReport() + "***** End of OpenGL Report *****\n");
            boolean intel = glGlobal.isIntel();
            if (win32 || macosx && intel) {
                int poolSize = win32 && intel ? 8 : 20;
                GLCapabilities canvasCap = (GLCapabilities)glGlobal.getCanvasCapabilities().cloneMutable();
                canvasCap.setDoubleBuffered(win32);
                glGlobal.enterPoolMode(poolSize);
                glGlobal.setCanvasCapabilities((GLCapabilitiesImmutable)canvasCap);
                GLCanvasFactory.getFactory().enterPoolMode(poolSize);
            }
        } else {
            configurer.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)"OpenGL\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (String)glGlobal.getInitError());
                    configurer.getWorkbench().close();
                }
            });
        }
        SplashProgressMonitor.worked(1);
        Initializer.initialize();
    }

    public boolean preShutdown() {
        LinkedHashSet windows = Util.newLinkedHashSet();
        IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow != null) {
            windows.add(activeWindow);
        }
        windows.addAll(Arrays.asList(workbench.getWorkbenchWindows()));
        for (IWorkbenchWindow window : windows) {
            ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
            if (pm == null || !ApplicationWorkbenchWindowAdvisor.saveConfirmationRequired(window)) continue;
            switch (SaveUtil.saveIfDirty(pm)) {
                case NOT_DIRTY: 
                case SAVED: 
                case UNSAVED: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        for (IWorkbenchWindow window : windows) {
            Perspective.reset(window);
        }
        return true;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "ch.kuramo.javie.app.perspective";
    }
}

