/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.ui.ResolutionResult;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;

public class PlannerResolutionOperation
extends ProvisioningOperation {
    ProfileChangeRequest request;
    String profileId;
    boolean isUser = true;
    ProvisioningPlan plan;
    MultiStatus additionalStatus;
    ResolutionResult report;
    ProvisioningContext provisioningContext;

    public PlannerResolutionOperation(String label, String profileId, ProfileChangeRequest request, ProvisioningContext provisioningContext, MultiStatus additionalStatus, boolean isUser) {
        super(label);
        this.request = request;
        this.profileId = profileId;
        this.isUser = isUser;
        this.provisioningContext = provisioningContext == null ? new ProvisioningContext() : provisioningContext;
        Assert.isNotNull((Object)additionalStatus);
        this.additionalStatus = additionalStatus;
    }

    public ProvisioningPlan getProvisioningPlan() {
        return this.plan;
    }

    public ProfileChangeRequest getProfileChangeRequest() {
        return this.request;
    }

    public ProvisioningContext getProvisioningContext() {
        return this.provisioningContext;
    }

    protected IStatus doExecute(IProgressMonitor monitor) throws ProvisionException {
        this.plan = ProvisioningUtil.getProvisioningPlan(this.request, this.provisioningContext, monitor);
        if (this.plan == null) {
            return new Status(4, "org.eclipse.equinox.p2.ui", 10050, ProvUIMessages.PlannerResolutionOperation_UnexpectedError, null);
        }
        return Status.OK_STATUS;
    }

    public ResolutionResult getResolutionResult() {
        if (this.report == null) {
            this.report = PlanAnalyzer.computeResolutionResult(this.request, this.plan, this.additionalStatus);
        }
        return this.report;
    }

    public boolean runInBackground() {
        return true;
    }

    public boolean isUser() {
        return this.isUser;
    }
}

