class com.macromedia.javascript.JavaScriptSerializer
{
    function JavaScriptSerializer()
    {
    } // End of the function
    static function serializeItem(item)
    {
        var _loc3 = typeof(item);
        var _loc1;
        switch (_loc3)
        {
            case "string":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.serializeString(String(item));
                break;
            } 
            case "number":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.serializeNumber(Number(item));
                break;
            } 
            case "boolean":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.serializeBoolean(Boolean(item));
                break;
            } 
            case "null":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.serializeNull();
                break;
            } 
            case "undefined":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.serializeUndefined();
                break;
            } 
            case "object":
            {
                if (item instanceof Date)
                {
                    _loc1 = com.macromedia.javascript.JavaScriptSerializer.serializeDate(new Date(item.getTime()));
                }
                else if (item instanceof Array)
                {
                    _loc1 = com.macromedia.javascript.JavaScriptSerializer.serializeArray(item);
                }
                else
                {
                    _loc1 = com.macromedia.javascript.JavaScriptSerializer.serializeObject(item);
                } // end else if
                break;
            } 
        } // End of switch
        return (_loc1);
    } // End of the function
    static function serializeObject(o)
    {
        var _loc2 = "{";
        for (var _loc3 in o)
        {
            if (typeof(_loc3[o]) == "function")
            {
                continue;
            } // end if
            _loc2 = _loc2 + (_loc3 + ":" + com.macromedia.javascript.JavaScriptSerializer.serializeItem(o[_loc3]) + ",");
        } // end of for...in
        if (_loc2.substring(_loc2.length - 1) == ",")
        {
            _loc2 = _loc2.substring(0, _loc2.length - 1);
        } // end if
        _loc2 = _loc2 + "}";
        return (_loc2);
    } // End of the function
    static function serializeArray(o)
    {
        var _loc3 = o.length;
        var _loc2 = "[";
        for (var _loc1 = 0; _loc1 < _loc3; ++_loc1)
        {
            _loc2 = _loc2 + com.macromedia.javascript.JavaScriptSerializer.serializeItem(o[_loc1]);
            if (_loc1 != _loc3 - 1)
            {
                _loc2 = _loc2 + ",";
            } // end if
        } // end of for
        _loc2 = _loc2 + "]";
        return (_loc2);
    } // End of the function
    static function serializeString(s)
    {
        return ("\'" + s + "\'");
    } // End of the function
    static function serializeNumber(n)
    {
        return (String(n));
    } // End of the function
    static function serializeBoolean(b)
    {
        return (String(b));
    } // End of the function
    static function serializeUndefined(Void)
    {
        return ("undefined");
    } // End of the function
    static function serializeNull(Void)
    {
        return ("null");
    } // End of the function
    static function serializeDate(d)
    {
        return ("new Date(" + d.getTime() + ")");
    } // End of the function
    static function deserializeItem(type, data)
    {
        var _loc1;
        switch (type)
        {
            case "str":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.deserializeString(data);
                break;
            } 
            case "num":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.deserializeNumber(data);
                break;
            } 
            case "bool":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.deserializeBoolean(data);
                break;
            } 
            case "null":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.deserializeNull();
                break;
            } 
            case "undf":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.deserializeUndefined();
                break;
            } 
            case "date":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.deserializeDate(data);
                break;
            } 
            case "xser":
            {
                _loc1 = com.macromedia.javascript.JavaScriptSerializer.deserializeXMLSerializedItem(data);
                trace (data);
                break;
            } 
        } // End of switch
        return (_loc1);
    } // End of the function
    static function deserializeString(s)
    {
        return (s);
    } // End of the function
    static function deserializeNumber(s)
    {
        return (Number(s));
    } // End of the function
    static function deserializeBoolean(s)
    {
        return (Boolean(s));
    } // End of the function
    static function deserializeUndefined(s)
    {
        return;
    } // End of the function
    static function deserializeNull(s)
    {
        return (null);
    } // End of the function
    static function deserializeDate(s)
    {
        return (new Date(Number(s)));
    } // End of the function
    static function deserializeXMLSerializedItem(data)
    {
        var _loc1 = new XML();
        _loc1.ignoreWhite = true;
        _loc1.parseXML(data);
        var _loc2 = com.macromedia.javascript.JavaScriptSerializer.parseNode(_loc1.firstChild.firstChild, new Object());
        return (_loc2);
    } // End of the function
    static function parseNode(x, o)
    {
        var _loc9 = x.nodeName;
        var _loc8 = x.firstChild.nodeValue;
        var _loc4 = x.attributes.name;
        var _loc5 = x.childNodes;
        var _loc6 = _loc5.length;
        switch (_loc9)
        {
            case "obj":
            {
                if (_loc4 == null)
                {
                    o = new Object();
                }
                else
                {
                    o[_loc4] = new Object();
                } // end else if
                break;
            } 
            case "str":
            {
                if (_loc4 == undefined)
                {
                    o = String(_loc8);
                }
                else
                {
                    o[_loc4] = _loc8;
                } // end else if
                break;
            } 
            case "num":
            {
                if (_loc4 == null)
                {
                    o = Number(_loc8);
                }
                else
                {
                    o[_loc4] = Number(_loc8);
                } // end else if
                break;
            } 
            case "bool":
            {
                if (_loc4 == null)
                {
                    o = Boolean(_loc8);
                }
                else
                {
                    o[_loc4] = Boolean(_loc8);
                } // end else if
                break;
            } 
            case "null":
            {
                if (_loc4 == null)
                {
                    o = null;
                }
                else
                {
                    o[_loc4] = null;
                } // end else if
                break;
            } 
            case "undf":
            {
                if (_loc4 == null)
                {
                }
                else
                {
                    o[_loc4] = undefined;
                } // end else if
                break;
            } 
            case "date":
            {
                if (_loc4 == null)
                {
                    o = new Date(Number(_loc8));
                }
                else
                {
                    o[_loc4] = new Date(Number(_loc8));
                } // end else if
                break;
            } 
            case "array":
            {
                var _loc7;
                if (_loc4 == null)
                {
                    o = new Array();
                    _loc7 = o;
                }
                else
                {
                    o[_loc4] = new Array();
                    _loc7 = o[_loc4];
                } // end else if
                for (var x = 0; x < _loc6; x = ++x)
                {
                    _loc7.push(com.macromedia.javascript.JavaScriptSerializer.parseNode(_loc5[x], o));
                } // end of for
                return (_loc7);
            } 
        } // End of switch
        for (var _loc2 = 0; _loc2 < _loc6; ++_loc2)
        {
            com.macromedia.javascript.JavaScriptSerializer.parseNode(_loc5[_loc2], o);
        } // end of for
        return (o);
    } // End of the function
} // End of Class
