
CREATE TABLE track_c_browsers (
  id int NOT NULL auto_increment,
  browser varchar(255) NOT NULL default '',
  counter int NOT NULL default 0,
  PRIMARY KEY  (id)
);

CREATE TABLE track_c_countries (
  id int NOT NULL auto_increment,
  code varchar(40) NOT NULL default '',
  country varchar(50) NOT NULL default '',
  counter int NOT NULL default 0,
  PRIMARY KEY  (id)
);

CREATE TABLE track_c_os (
  id int NOT NULL auto_increment,
  os varchar(255) NOT NULL default '',
  counter int NOT NULL default 0,
  PRIMARY KEY  (id)
);

CREATE TABLE track_c_providers (
  id int NOT NULL auto_increment,
  provider varchar(255) NOT NULL default '',
  counter int NOT NULL default 0,
  PRIMARY KEY  (id)
);

CREATE TABLE track_c_referers (
  id int NOT NULL auto_increment,
  referer varchar(255) NOT NULL default '',
  counter int NOT NULL default 0,
  PRIMARY KEY  (id)
);

CREATE TABLE track_e_access (
  access_id int NOT NULL auto_increment,
  access_user_id int unsigned default NULL,
  access_date datetime NOT NULL default '0000-00-00 00:00:00',
  access_cours_code varchar(40) NOT NULL default '',
  access_tool varchar(30) default NULL,
  PRIMARY KEY  (access_id),
  KEY access_user_id (access_user_id),
  KEY access_cours_code (access_cours_code)
);

CREATE TABLE track_e_lastaccess (
  access_id bigint NOT NULL auto_increment,
  access_user_id int unsigned default NULL,
  access_date datetime NOT NULL default '0000-00-00 00:00:00',
  access_cours_code varchar(40) NOT NULL,
  access_tool varchar(30) default NULL,
  access_session_id int unsigned default NULL,
  PRIMARY KEY  (access_id),
  KEY access_user_id (access_user_id),
  KEY access_cours_code (access_cours_code)
);

CREATE TABLE track_e_default (
  default_id int NOT NULL auto_increment,
  default_user_id int unsigned NOT NULL default 0,
  default_cours_code varchar(40) NOT NULL default '',
  default_date datetime NOT NULL default '0000-00-00 00:00:00',
  default_event_type varchar(20) NOT NULL default '',
  default_value_type varchar(20) NOT NULL default '',
  default_value tinytext NOT NULL,
  PRIMARY KEY  (default_id)
);

CREATE TABLE track_e_downloads (
  down_id int NOT NULL auto_increment,
  down_user_id int unsigned default NULL,
  down_date datetime NOT NULL default '0000-00-00 00:00:00',
  down_cours_id varchar(40) NOT NULL default '',
  down_doc_path varchar(255) NOT NULL default '',
  PRIMARY KEY  (down_id)
);

CREATE TABLE track_e_exercices (
  exe_id int NOT NULL auto_increment,
  exe_user_id int unsigned default NULL,
  exe_date datetime NOT NULL default '0000-00-00 00:00:00',
  exe_cours_id varchar(40) NOT NULL default '',
  exe_exo_id mediumint unsigned NOT NULL default 0,
  exe_result smallint NOT NULL default 0,
  exe_weighting smallint NOT NULL default 0,
  PRIMARY KEY  (exe_id)
);

CREATE TABLE track_e_attempt (
  exe_id int default NULL,
  user_id int NOT NULL default 0,
  question_id int NOT NULL default 0,
  answer text NOT NULL,
  teacher_comment text NOT NULL,
  marks int NOT NULL default 0,
  course_code varchar(40) NOT NULL default '',
  position int default 0
);

CREATE TABLE track_e_hotpotatoes (
  exe_name VARCHAR( 255 ) NOT NULL ,
  exe_user_id int unsigned DEFAULT NULL ,
  exe_date DATETIME DEFAULT '0000-00-00 00:00:00' NOT NULL ,
  exe_cours_id varchar(40) NOT NULL ,
  exe_result smallint default 0 NOT NULL ,
  exe_weighting smallint default 0 NOT NULL
);

CREATE TABLE track_e_links (
  links_id int NOT NULL auto_increment,
  links_user_id int unsigned default NULL,
  links_date datetime NOT NULL default '0000-00-00 00:00:00',
  links_cours_id varchar(40) NOT NULL default '' ,
  links_link_id int NOT NULL default 0,
  PRIMARY KEY  (links_id)
);

CREATE TABLE track_e_login (
  login_id int NOT NULL auto_increment,
  login_user_id int unsigned NOT NULL default 0,
  login_date datetime NOT NULL default '0000-00-00 00:00:00',
  login_ip varchar(39) NOT NULL default '',
  logout_date datetime NULL default NULL,
  PRIMARY KEY  (login_id),
  KEY login_user_id (login_user_id)
);

CREATE TABLE track_e_online (
  login_id int NOT NULL auto_increment,
  login_user_id int unsigned NOT NULL default 0,
  login_date datetime NOT NULL default '0000-00-00 00:00:00',
  login_ip varchar(39) NOT NULL default '',
  course varchar(40) default NULL,
  PRIMARY KEY  (login_id),
  KEY login_user_id (login_user_id)
);

CREATE TABLE track_e_open (
  open_id int NOT NULL auto_increment,
  open_remote_host tinytext NOT NULL,
  open_agent tinytext NOT NULL,
  open_referer tinytext NOT NULL,
  open_date datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (open_id)
);

CREATE TABLE track_e_uploads (
  upload_id int NOT NULL auto_increment,
  upload_user_id int unsigned default NULL,
  upload_date datetime NOT NULL default '0000-00-00 00:00:00',
  upload_cours_id varchar(40) NOT NULL default '',
  upload_work_id int NOT NULL default 0,
  PRIMARY KEY  (upload_id)
);

CREATE TABLE track_e_course_access (
  course_access_id int NOT NULL auto_increment,
  course_code varchar(40) NOT NULL,
  user_id int NOT NULL,
  login_course_date datetime NOT NULL default '0000-00-00 00:00:00',
  logout_course_date datetime default NULL,
  counter int NOT NULL,
  PRIMARY KEY  (course_access_id)
);