<?php
/*
===============================================================================
	IILearn - elearning and course management software

	Copyright (c) 2007 iilearn.org China

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: www.iilearn.org, poopsoft@163.com
===============================================================================
*/
/**
============================================================================== 
*	Main page for the group module.
*	This script displays the general group settings, 
*	and a list of groups with buttons to view, edit...
*	
*	@author Thomas Depraetere, Hugues Peeters, Christophe Gesche: initial versions
*	@author Bert Vanderkimpen, improved self-unsubscribe for cvs
*	@author Patrick Cool, show group comment under the group name
*	@author Roan Embrechts, initial self-unsubscribe code, code cleaning, virtual course support
*	@author Bart Mollet, code cleaning, use of Display-library, list of courseAdmin-tools, use of GroupManager
*	@package dokeos.group
============================================================================== 
*/
/*
============================================================================== 
		INIT SECTION
============================================================================== 
*/
// name of the language file that needs to be included 
$language_file = array('group','admin');

include ('../inc/global.inc.php');
$this_section=SECTION_COURSES;

$nameTools = get_lang("GroupOverview");

/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/
include_once (api_get_path(LIBRARY_PATH).'course.lib.php'); //necessary
include_once (api_get_path(LIBRARY_PATH).'groupmanager.lib.php');
include_once (api_get_path(LIBRARY_PATH).'export.lib.inc.php');
include_once (api_get_path(LIBRARY_PATH).'events.lib.inc.php'); //necessary for statistics
include_once (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');

/*
-----------------------------------------------------------
	Main Code
-----------------------------------------------------------
*/
$interbreadcrumb[]=array("url" => "group.php","name" => get_lang('GroupManagement'));

$form = new FormValidator('export_groups');

$form->addElement('header', 'header', get_lang('GroupOverview'));

$group = array();
$group[] = $form->createElement('radio', 'file_type', null, 'Excel','xls');
$group[] = $form->createElement('radio', 'file_type', null, 'CSV','csv');
$form->addGroup($group,'file_type',get_lang('OutputFileType'),null,false);

$encodings = array('UTF-8'=>'UTF-8','GB2312'=>'GB2312','BIG5'=>'BIG5','EUC-JP'=>'EUC-JP');
$form->addElement('select', 'export_encoding', get_lang('ExportEncoding'), $encodings);

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Ok'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

$form->setDefaults(array('file_type'=>'xls'));

Display::setTemplateBorder($form, '60%');

if ($form->validate()) {
	$export = $form->exportValues();
	$file_type = $export['file_type'];
	$export_encoding = $export['export_encoding'];
	
	$groups = GroupManager::get_group_list();
	$data = array();
	foreach($groups as $index => $group)
	{
		$users = GroupManager::get_users($group['id']);
		foreach($users as $index => $user)
		{
			$user = api_get_user_info($user);

			if (strtolower($export_encoding) != strtolower(SYSTEM_CHARSET)) {
				$group_name = mb_convert_encoding($group['name'], $export_encoding, SYSTEM_CHARSET);
				$user['lastName'] = mb_convert_encoding($user['lastName'], $export_encoding, SYSTEM_CHARSET);
				$user['firstName'] = mb_convert_encoding($user['firstName'], $export_encoding, SYSTEM_CHARSET);
			}

			$row = array();
			$row[] = $group_name;
			$row[] = $user['official_code'];
			$row[] = $user['lastName'];
			$row[] = $user['firstName'];
			$data[] = $row;
		}	
	}	

	$filename = 'export_groups_' . $_course['sysCode'] . '_' . date('Y-m-d_H-i-s');
	switch($file_type)
	{
		case 'csv':
			Export::export_table_csv($data, $filename);
 			break;
		case 'xls':
			Export::export_table_xls($data, $filename);	
 			break;
	}	
}

if (!isset ($_GET['origin']) || $_GET['origin'] != 'learnpath')
{ 
	//so we are not in learnpath tool
	Display::display_header($nameTools,"Group");
	//event_access_tool($nameTools);
	//api_display_tool_title($nameTools);
	if (! $is_allowed_in_course) api_not_allowed();
}
else
{
?> <link rel="stylesheet" type="text/css" href="<?php echo api_get_path(WEB_CODE_PATH); ?>css/default/default.css" /> <?php
}

$form->display();

/*
============================================================================== 
		FOOTER 
============================================================================== 
*/
if (!isset ($_GET['origin']) || $_GET['origin'] != 'learnpath')
{
	Display::display_footer();
}
?>