/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XOutputStream;
import com.sun.star.lib.uno.helper.ComponentBase;

public class XOutputStreamToByteArrayAdapter
extends ComponentBase
implements XOutputStream {
    private int initialSize;
    private int size;
    private int position;
    private boolean externalBuffer;
    private boolean closed;
    private byte[] buffer;

    private /* synthetic */ void finit$() {
        this.initialSize = 100240;
        this.size = 0;
        this.position = 0;
        this.externalBuffer = false;
        this.closed = false;
    }

    public XOutputStreamToByteArrayAdapter() {
        this(null);
    }

    public XOutputStreamToByteArrayAdapter(byte[] byArray) {
        this.finit$();
        if (byArray != null) {
            this.externalBuffer = true;
            this.buffer = byArray;
            this.size = this.buffer.length;
        } else {
            this.size = this.initialSize;
            this.buffer = new byte[this.size];
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void closeOutput() throws NotConnectedException, BufferSizeExceededException, IOException {
        if (this.buffer.length > this.position && !this.externalBuffer) {
            byte[] byArray = new byte[this.position];
            System.arraycopy(this.buffer, 0, byArray, 0, this.position);
            this.buffer = byArray;
        }
        this.closed = true;
    }

    public void flush() throws NotConnectedException, BufferSizeExceededException, IOException {
    }

    public void writeBytes(byte[] byArray) throws NotConnectedException, BufferSizeExceededException, IOException {
        if (byArray.length > this.size - this.position) {
            if (this.externalBuffer) {
                throw new BufferSizeExceededException("out of buffer space, cannot grow external buffer");
            }
            byte[] byArray2 = null;
            while (byArray.length > this.size - this.position) {
                this.size *= 2;
            }
            byArray2 = new byte[this.size];
            System.arraycopy(this.buffer, 0, byArray2, 0, this.position);
            this.buffer = byArray2;
        }
        System.arraycopy(byArray, 0, this.buffer, this.position, byArray.length);
        this.position += byArray.length;
    }
}

