/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.SortedIntDocSet;

public class DocSetDelegateCollector
extends DocSetCollector {
    final Collector collector;

    public DocSetDelegateCollector(int smallSetSize, int maxDoc, Collector collector) {
        super(smallSetSize, maxDoc);
        this.collector = collector;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.collector.collect(doc);
        doc += this.base;
        if (this.pos < this.scratch.length) {
            this.scratch[this.pos] = doc;
        } else {
            if (this.bits == null) {
                this.bits = new FixedBitSet(this.maxDoc);
            }
            this.bits.set(doc);
        }
        ++this.pos;
    }

    @Override
    public DocSet getDocSet() {
        if (this.pos <= this.scratch.length) {
            return new SortedIntDocSet(this.scratch, this.pos);
        }
        for (int i = 0; i < this.scratch.length; ++i) {
            this.bits.set(this.scratch[i]);
        }
        return new BitDocSet(this.bits, this.pos);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.collector.setNextReader(context);
        this.base = context.docBase;
    }
}

